/* 
 * This file is part of the UCB release of Plan 9. It is subject to the license
 * terms in the LICENSE file found in the top-level directory of this
 * distribution and at http://akaros.cs.berkeley.edu/files/Plan9License. No
 * part of the UCB release of Plan 9, including this file, may be copied,
 * modified, propagated, or distributed except according to the terms contained
 * in the LICENSE file.
 */

/*
 * pANS stdio -- sopenw
 */
#include "iolib.h"
FILE *sopenw(void){
	FILE *f;
	qlock(&_stdiolk);
	for(f=_IO_stream;f!=&_IO_stream[FOPEN_MAX];f++) if(f->state==CLOSED) break;
	if(f==&_IO_stream[FOPEN_MAX]) {
		qunlock(&_stdiolk);
		return NULL;
	}
	f->buf=f->rp=f->wp=0;
	f->state=OPEN;
	f->flags=STRING;
	f->fd=-1;
	qunlock(&_stdiolk);
	return f;
}
