/* 
 * This file is part of the UCB release of Plan 9. It is subject to the license
 * terms in the LICENSE file found in the top-level directory of this
 * distribution and at http://akaros.cs.berkeley.edu/files/Plan9License. No
 * part of the UCB release of Plan 9, including this file, may be copied,
 * modified, propagated, or distributed except according to the terms contained
 * in the LICENSE file.
 */

#include <u.h>
#include <libc.h>

Rune*_runebsearch(Rune c, Rune *t, int n, int ne);

static Rune	_base2[] =
{
	0x00c0,	0x0041,	/* À A */
	0x00c1,	0x0041,	/* Á A */
	0x00c2,	0x0041,	/* Â A */
	0x00c3,	0x0041,	/* Ã A */
	0x00c4,	0x0041,	/* Ä A */
	0x00c5,	0x0041,	/* Å A */
	0x00c7,	0x0043,	/* Ç C */
	0x00c8,	0x0045,	/* È E */
	0x00c9,	0x0045,	/* É E */
	0x00ca,	0x0045,	/* Ê E */
	0x00cb,	0x0045,	/* Ë E */
	0x00cc,	0x0049,	/* Ì I */
	0x00cd,	0x0049,	/* Í I */
	0x00ce,	0x0049,	/* Î I */
	0x00cf,	0x0049,	/* Ï I */
	0x00d1,	0x004e,	/* Ñ N */
	0x00d2,	0x004f,	/* Ò O */
	0x00d3,	0x004f,	/* Ó O */
	0x00d4,	0x004f,	/* Ô O */
	0x00d5,	0x004f,	/* Õ O */
	0x00d6,	0x004f,	/* Ö O */
	0x00d9,	0x0055,	/* Ù U */
	0x00da,	0x0055,	/* Ú U */
	0x00db,	0x0055,	/* Û U */
	0x00dc,	0x0055,	/* Ü U */
	0x00dd,	0x0059,	/* Ý Y */
	0x00e0,	0x0061,	/* à a */
	0x00e1,	0x0061,	/* á a */
	0x00e2,	0x0061,	/* â a */
	0x00e3,	0x0061,	/* ã a */
	0x00e4,	0x0061,	/* ä a */
	0x00e5,	0x0061,	/* å a */
	0x00e7,	0x0063,	/* ç c */
	0x00e8,	0x0065,	/* è e */
	0x00e9,	0x0065,	/* é e */
	0x00ea,	0x0065,	/* ê e */
	0x00eb,	0x0065,	/* ë e */
	0x00ec,	0x0069,	/* ì i */
	0x00ed,	0x0069,	/* í i */
	0x00ee,	0x0069,	/* î i */
	0x00ef,	0x0069,	/* ï i */
	0x00f1,	0x006e,	/* ñ n */
	0x00f2,	0x006f,	/* ò o */
	0x00f3,	0x006f,	/* ó o */
	0x00f4,	0x006f,	/* ô o */
	0x00f5,	0x006f,	/* õ o */
	0x00f6,	0x006f,	/* ö o */
	0x00f9,	0x0075,	/* ù u */
	0x00fa,	0x0075,	/* ú u */
	0x00fb,	0x0075,	/* û u */
	0x00fc,	0x0075,	/* ü u */
	0x00fd,	0x0079,	/* ý y */
	0x00ff,	0x0079,	/* ÿ y */
	0x0100,	0x0041,	/* Ā A */
	0x0101,	0x0061,	/* ā a */
	0x0102,	0x0041,	/* Ă A */
	0x0103,	0x0061,	/* ă a */
	0x0104,	0x0041,	/* Ą A */
	0x0105,	0x0061,	/* ą a */
	0x0106,	0x0043,	/* Ć C */
	0x0107,	0x0063,	/* ć c */
	0x0108,	0x0043,	/* Ĉ C */
	0x0109,	0x0063,	/* ĉ c */
	0x010a,	0x0043,	/* Ċ C */
	0x010b,	0x0063,	/* ċ c */
	0x010c,	0x0043,	/* Č C */
	0x010d,	0x0063,	/* č c */
	0x010e,	0x0044,	/* Ď D */
	0x010f,	0x0064,	/* ď d */
	0x0112,	0x0045,	/* Ē E */
	0x0113,	0x0065,	/* ē e */
	0x0114,	0x0045,	/* Ĕ E */
	0x0115,	0x0065,	/* ĕ e */
	0x0116,	0x0045,	/* Ė E */
	0x0117,	0x0065,	/* ė e */
	0x0118,	0x0045,	/* Ę E */
	0x0119,	0x0065,	/* ę e */
	0x011a,	0x0045,	/* Ě E */
	0x011b,	0x0065,	/* ě e */
	0x011c,	0x0047,	/* Ĝ G */
	0x011d,	0x0067,	/* ĝ g */
	0x011e,	0x0047,	/* Ğ G */
	0x011f,	0x0067,	/* ğ g */
	0x0120,	0x0047,	/* Ġ G */
	0x0121,	0x0067,	/* ġ g */
	0x0122,	0x0047,	/* Ģ G */
	0x0123,	0x0067,	/* ģ g */
	0x0124,	0x0048,	/* Ĥ H */
	0x0125,	0x0068,	/* ĥ h */
	0x0128,	0x0049,	/* Ĩ I */
	0x0129,	0x0069,	/* ĩ i */
	0x012a,	0x0049,	/* Ī I */
	0x012b,	0x0069,	/* ī i */
	0x012c,	0x0049,	/* Ĭ I */
	0x012d,	0x0069,	/* ĭ i */
	0x012e,	0x0049,	/* Į I */
	0x012f,	0x0069,	/* į i */
	0x0130,	0x0049,	/* İ I */
	0x0134,	0x004a,	/* Ĵ J */
	0x0135,	0x006a,	/* ĵ j */
	0x0136,	0x004b,	/* Ķ K */
	0x0137,	0x006b,	/* ķ k */
	0x0139,	0x004c,	/* Ĺ L */
	0x013a,	0x006c,	/* ĺ l */
	0x013b,	0x004c,	/* Ļ L */
	0x013c,	0x006c,	/* ļ l */
	0x013d,	0x004c,	/* Ľ L */
	0x013e,	0x006c,	/* ľ l */
	0x0143,	0x004e,	/* Ń N */
	0x0144,	0x006e,	/* ń n */
	0x0145,	0x004e,	/* Ņ N */
	0x0146,	0x006e,	/* ņ n */
	0x0147,	0x004e,	/* Ň N */
	0x0148,	0x006e,	/* ň n */
	0x014c,	0x004f,	/* Ō O */
	0x014d,	0x006f,	/* ō o */
	0x014e,	0x004f,	/* Ŏ O */
	0x014f,	0x006f,	/* ŏ o */
	0x0150,	0x004f,	/* Ő O */
	0x0151,	0x006f,	/* ő o */
	0x0154,	0x0052,	/* Ŕ R */
	0x0155,	0x0072,	/* ŕ r */
	0x0156,	0x0052,	/* Ŗ R */
	0x0157,	0x0072,	/* ŗ r */
	0x0158,	0x0052,	/* Ř R */
	0x0159,	0x0072,	/* ř r */
	0x015a,	0x0053,	/* Ś S */
	0x015b,	0x0073,	/* ś s */
	0x015c,	0x0053,	/* Ŝ S */
	0x015d,	0x0073,	/* ŝ s */
	0x015e,	0x0053,	/* Ş S */
	0x015f,	0x0073,	/* ş s */
	0x0160,	0x0053,	/* Š S */
	0x0161,	0x0073,	/* š s */
	0x0162,	0x0054,	/* Ţ T */
	0x0163,	0x0074,	/* ţ t */
	0x0164,	0x0054,	/* Ť T */
	0x0165,	0x0074,	/* ť t */
	0x0168,	0x0055,	/* Ũ U */
	0x0169,	0x0075,	/* ũ u */
	0x016a,	0x0055,	/* Ū U */
	0x016b,	0x0075,	/* ū u */
	0x016c,	0x0055,	/* Ŭ U */
	0x016d,	0x0075,	/* ŭ u */
	0x016e,	0x0055,	/* Ů U */
	0x016f,	0x0075,	/* ů u */
	0x0170,	0x0055,	/* Ű U */
	0x0171,	0x0075,	/* ű u */
	0x0172,	0x0055,	/* Ų U */
	0x0173,	0x0075,	/* ų u */
	0x0174,	0x0057,	/* Ŵ W */
	0x0175,	0x0077,	/* ŵ w */
	0x0176,	0x0059,	/* Ŷ Y */
	0x0177,	0x0079,	/* ŷ y */
	0x0178,	0x0059,	/* Ÿ Y */
	0x0179,	0x005a,	/* Ź Z */
	0x017a,	0x007a,	/* ź z */
	0x017b,	0x005a,	/* Ż Z */
	0x017c,	0x007a,	/* ż z */
	0x017d,	0x005a,	/* Ž Z */
	0x017e,	0x007a,	/* ž z */
	0x01a0,	0x004f,	/* Ơ O */
	0x01a1,	0x006f,	/* ơ o */
	0x01af,	0x0055,	/* Ư U */
	0x01b0,	0x0075,	/* ư u */
	0x01cd,	0x0041,	/* Ǎ A */
	0x01ce,	0x0061,	/* ǎ a */
	0x01cf,	0x0049,	/* Ǐ I */
	0x01d0,	0x0069,	/* ǐ i */
	0x01d1,	0x004f,	/* Ǒ O */
	0x01d2,	0x006f,	/* ǒ o */
	0x01d3,	0x0055,	/* Ǔ U */
	0x01d4,	0x0075,	/* ǔ u */
	0x01d5,	0x0055,	/* Ǖ U */
	0x01d6,	0x0075,	/* ǖ u */
	0x01d7,	0x0055,	/* Ǘ U */
	0x01d8,	0x0075,	/* ǘ u */
	0x01d9,	0x0055,	/* Ǚ U */
	0x01da,	0x0075,	/* ǚ u */
	0x01db,	0x0055,	/* Ǜ U */
	0x01dc,	0x0075,	/* ǜ u */
	0x01de,	0x0041,	/* Ǟ A */
	0x01df,	0x0061,	/* ǟ a */
	0x01e0,	0x0041,	/* Ǡ A */
	0x01e1,	0x0061,	/* ǡ a */
	0x01e2,	0x00c6,	/* Ǣ Æ */
	0x01e3,	0x00e6,	/* ǣ æ */
	0x01e6,	0x0047,	/* Ǧ G */
	0x01e7,	0x0067,	/* ǧ g */
	0x01e8,	0x004b,	/* Ǩ K */
	0x01e9,	0x006b,	/* ǩ k */
	0x01ea,	0x004f,	/* Ǫ O */
	0x01eb,	0x006f,	/* ǫ o */
	0x01ec,	0x004f,	/* Ǭ O */
	0x01ed,	0x006f,	/* ǭ o */
	0x01ee,	0x01b7,	/* Ǯ Ʒ */
	0x01ef,	0x0292,	/* ǯ ʒ */
	0x01f0,	0x006a,	/* ǰ j */
	0x01f4,	0x0047,	/* Ǵ G */
	0x01f5,	0x0067,	/* ǵ g */
	0x01f8,	0x004e,	/* Ǹ N */
	0x01f9,	0x006e,	/* ǹ n */
	0x01fa,	0x0041,	/* Ǻ A */
	0x01fb,	0x0061,	/* ǻ a */
	0x01fc,	0x00c6,	/* Ǽ Æ */
	0x01fd,	0x00e6,	/* ǽ æ */
	0x01fe,	0x00d8,	/* Ǿ Ø */
	0x01ff,	0x00f8,	/* ǿ ø */
	0x0200,	0x0041,	/* Ȁ A */
	0x0201,	0x0061,	/* ȁ a */
	0x0202,	0x0041,	/* Ȃ A */
	0x0203,	0x0061,	/* ȃ a */
	0x0204,	0x0045,	/* Ȅ E */
	0x0205,	0x0065,	/* ȅ e */
	0x0206,	0x0045,	/* Ȇ E */
	0x0207,	0x0065,	/* ȇ e */
	0x0208,	0x0049,	/* Ȉ I */
	0x0209,	0x0069,	/* ȉ i */
	0x020a,	0x0049,	/* Ȋ I */
	0x020b,	0x0069,	/* ȋ i */
	0x020c,	0x004f,	/* Ȍ O */
	0x020d,	0x006f,	/* ȍ o */
	0x020e,	0x004f,	/* Ȏ O */
	0x020f,	0x006f,	/* ȏ o */
	0x0210,	0x0052,	/* Ȑ R */
	0x0211,	0x0072,	/* ȑ r */
	0x0212,	0x0052,	/* Ȓ R */
	0x0213,	0x0072,	/* ȓ r */
	0x0214,	0x0055,	/* Ȕ U */
	0x0215,	0x0075,	/* ȕ u */
	0x0216,	0x0055,	/* Ȗ U */
	0x0217,	0x0075,	/* ȗ u */
	0x0218,	0x0053,	/* Ș S */
	0x0219,	0x0073,	/* ș s */
	0x021a,	0x0054,	/* Ț T */
	0x021b,	0x0074,	/* ț t */
	0x021e,	0x0048,	/* Ȟ H */
	0x021f,	0x0068,	/* ȟ h */
	0x0226,	0x0041,	/* Ȧ A */
	0x0227,	0x0061,	/* ȧ a */
	0x0228,	0x0045,	/* Ȩ E */
	0x0229,	0x0065,	/* ȩ e */
	0x022a,	0x004f,	/* Ȫ O */
	0x022b,	0x006f,	/* ȫ o */
	0x022c,	0x004f,	/* Ȭ O */
	0x022d,	0x006f,	/* ȭ o */
	0x022e,	0x004f,	/* Ȯ O */
	0x022f,	0x006f,	/* ȯ o */
	0x0230,	0x004f,	/* Ȱ O */
	0x0231,	0x006f,	/* ȱ o */
	0x0232,	0x0059,	/* Ȳ Y */
	0x0233,	0x0079,	/* ȳ y */
	0x0374,	0x02b9,	/* ʹ ʹ */
	0x0386,	0x0391,	/* Ά Α */
	0x0388,	0x0395,	/* Έ Ε */
	0x0389,	0x0397,	/* Ή Η */
	0x038a,	0x0399,	/* Ί Ι */
	0x038c,	0x039f,	/* Ό Ο */
	0x038e,	0x03a5,	/* Ύ Υ */
	0x038f,	0x03a9,	/* Ώ Ω */
	0x0390,	0x03b9,	/* ΐ ι */
	0x03aa,	0x0399,	/* Ϊ Ι */
	0x03ab,	0x03a5,	/* Ϋ Υ */
	0x03ac,	0x03b1,	/* ά α */
	0x03ad,	0x03b5,	/* έ ε */
	0x03ae,	0x03b7,	/* ή η */
	0x03af,	0x03b9,	/* ί ι */
	0x03b0,	0x03c5,	/* ΰ υ */
	0x03ca,	0x03b9,	/* ϊ ι */
	0x03cb,	0x03c5,	/* ϋ υ */
	0x03cc,	0x03bf,	/* ό ο */
	0x03cd,	0x03c5,	/* ύ υ */
	0x03ce,	0x03c9,	/* ώ ω */
	0x03d3,	0x03d2,	/* ϓ ϒ */
	0x03d4,	0x03d2,	/* ϔ ϒ */
	0x0400,	0x0415,	/* Ѐ Е */
	0x0401,	0x0415,	/* Ё Е */
	0x0403,	0x0413,	/* Ѓ Г */
	0x0407,	0x0406,	/* Ї І */
	0x040c,	0x041a,	/* Ќ К */
	0x040d,	0x0418,	/* Ѝ И */
	0x040e,	0x0423,	/* Ў У */
	0x0419,	0x0418,	/* Й И */
	0x0439,	0x0438,	/* й и */
	0x0450,	0x0435,	/* ѐ е */
	0x0451,	0x0435,	/* ё е */
	0x0453,	0x0433,	/* ѓ г */
	0x0457,	0x0456,	/* ї і */
	0x045c,	0x043a,	/* ќ к */
	0x045d,	0x0438,	/* ѝ и */
	0x045e,	0x0443,	/* ў у */
	0x0476,	0x0474,	/* Ѷ Ѵ */
	0x0477,	0x0475,	/* ѷ ѵ */
	0x04c1,	0x0416,	/* Ӂ Ж */
	0x04c2,	0x0436,	/* ӂ ж */
	0x04d0,	0x0410,	/* Ӑ А */
	0x04d1,	0x0430,	/* ӑ а */
	0x04d2,	0x0410,	/* Ӓ А */
	0x04d3,	0x0430,	/* ӓ а */
	0x04d6,	0x0415,	/* Ӗ Е */
	0x04d7,	0x0435,	/* ӗ е */
	0x04da,	0x04d8,	/* Ӛ Ә */
	0x04db,	0x04d9,	/* ӛ ә */
	0x04dc,	0x0416,	/* Ӝ Ж */
	0x04dd,	0x0436,	/* ӝ ж */
	0x04de,	0x0417,	/* Ӟ З */
	0x04df,	0x0437,	/* ӟ з */
	0x04e2,	0x0418,	/* Ӣ И */
	0x04e3,	0x0438,	/* ӣ и */
	0x04e4,	0x0418,	/* Ӥ И */
	0x04e5,	0x0438,	/* ӥ и */
	0x04e6,	0x041e,	/* Ӧ О */
	0x04e7,	0x043e,	/* ӧ о */
	0x04ea,	0x04e8,	/* Ӫ Ө */
	0x04eb,	0x04e9,	/* ӫ ө */
	0x04ec,	0x042d,	/* Ӭ Э */
	0x04ed,	0x044d,	/* ӭ э */
	0x04ee,	0x0423,	/* Ӯ У */
	0x04ef,	0x0443,	/* ӯ у */
	0x04f0,	0x0423,	/* Ӱ У */
	0x04f1,	0x0443,	/* ӱ у */
	0x04f2,	0x0423,	/* Ӳ У */
	0x04f3,	0x0443,	/* ӳ у */
	0x04f4,	0x0427,	/* Ӵ Ч */
	0x04f5,	0x0447,	/* ӵ ч */
	0x04f8,	0x042b,	/* Ӹ Ы */
	0x04f9,	0x044b,	/* ӹ ы */
	0x0622,	0x0627,	/* آ ا */
	0x0623,	0x0627,	/* أ ا */
	0x0624,	0x0648,	/* ؤ و */
	0x0625,	0x0627,	/* إ ا */
	0x0626,	0x064a,	/* ئ ي */
	0x06c0,	0x06d5,	/* ۀ ە */
	0x06c2,	0x06c1,	/* ۂ ہ */
	0x06d3,	0x06d2,	/* ۓ ے */
	0x0929,	0x0928,	/* ऩ न */
	0x0931,	0x0930,	/* ऱ र */
	0x0934,	0x0933,	/* ऴ ळ */
	0x0958,	0x0915,	/* क़ क */
	0x0959,	0x0916,	/* ख़ ख */
	0x095a,	0x0917,	/* ग़ ग */
	0x095b,	0x091c,	/* ज़ ज */
	0x095c,	0x0921,	/* ड़ ड */
	0x095d,	0x0922,	/* ढ़ ढ */
	0x095e,	0x092b,	/* फ़ फ */
	0x095f,	0x092f,	/* य़ य */
	0x09dc,	0x09a1,	/* ড় ড */
	0x09dd,	0x09a2,	/* ঢ় ঢ */
	0x09df,	0x09af,	/* য় য */
	0x0a33,	0x0a32,	/* ਲ਼ ਲ */
	0x0a36,	0x0a38,	/* ਸ਼ ਸ */
	0x0a59,	0x0a16,	/* ਖ਼ ਖ */
	0x0a5a,	0x0a17,	/* ਗ਼ ਗ */
	0x0a5b,	0x0a1c,	/* ਜ਼ ਜ */
	0x0a5e,	0x0a2b,	/* ਫ਼ ਫ */
	0x0b5c,	0x0b21,	/* ଡ଼ ଡ */
	0x0b5d,	0x0b22,	/* ଢ଼ ଢ */
	0x0b94,	0x0b92,	/* ஔ ஒ */
	0x0f43,	0x0f42,	/* གྷ ག */
	0x0f4d,	0x0f4c,	/* ཌྷ ཌ */
	0x0f52,	0x0f51,	/* དྷ ད */
	0x0f57,	0x0f56,	/* བྷ བ */
	0x0f5c,	0x0f5b,	/* ཛྷ ཛ */
	0x0f69,	0x0f40,	/* ཀྵ ཀ */
	0x1026,	0x1025,	/* ဦ ဥ */
	0x1b06,	0x1b05,	/* ᬆ ᬅ */
	0x1b08,	0x1b07,	/* ᬈ ᬇ */
	0x1b0a,	0x1b09,	/* ᬊ ᬉ */
	0x1b0c,	0x1b0b,	/* ᬌ ᬋ */
	0x1b0e,	0x1b0d,	/* ᬎ ᬍ */
	0x1b12,	0x1b11,	/* ᬒ ᬑ */
	0x1e00,	0x0041,	/* Ḁ A */
	0x1e01,	0x0061,	/* ḁ a */
	0x1e02,	0x0042,	/* Ḃ B */
	0x1e03,	0x0062,	/* ḃ b */
	0x1e04,	0x0042,	/* Ḅ B */
	0x1e05,	0x0062,	/* ḅ b */
	0x1e06,	0x0042,	/* Ḇ B */
	0x1e07,	0x0062,	/* ḇ b */
	0x1e08,	0x0043,	/* Ḉ C */
	0x1e09,	0x0063,	/* ḉ c */
	0x1e0a,	0x0044,	/* Ḋ D */
	0x1e0b,	0x0064,	/* ḋ d */
	0x1e0c,	0x0044,	/* Ḍ D */
	0x1e0d,	0x0064,	/* ḍ d */
	0x1e0e,	0x0044,	/* Ḏ D */
	0x1e0f,	0x0064,	/* ḏ d */
	0x1e10,	0x0044,	/* Ḑ D */
	0x1e11,	0x0064,	/* ḑ d */
	0x1e12,	0x0044,	/* Ḓ D */
	0x1e13,	0x0064,	/* ḓ d */
	0x1e14,	0x0045,	/* Ḕ E */
	0x1e15,	0x0065,	/* ḕ e */
	0x1e16,	0x0045,	/* Ḗ E */
	0x1e17,	0x0065,	/* ḗ e */
	0x1e18,	0x0045,	/* Ḙ E */
	0x1e19,	0x0065,	/* ḙ e */
	0x1e1a,	0x0045,	/* Ḛ E */
	0x1e1b,	0x0065,	/* ḛ e */
	0x1e1c,	0x0045,	/* Ḝ E */
	0x1e1d,	0x0065,	/* ḝ e */
	0x1e1e,	0x0046,	/* Ḟ F */
	0x1e1f,	0x0066,	/* ḟ f */
	0x1e20,	0x0047,	/* Ḡ G */
	0x1e21,	0x0067,	/* ḡ g */
	0x1e22,	0x0048,	/* Ḣ H */
	0x1e23,	0x0068,	/* ḣ h */
	0x1e24,	0x0048,	/* Ḥ H */
	0x1e25,	0x0068,	/* ḥ h */
	0x1e26,	0x0048,	/* Ḧ H */
	0x1e27,	0x0068,	/* ḧ h */
	0x1e28,	0x0048,	/* Ḩ H */
	0x1e29,	0x0068,	/* ḩ h */
	0x1e2a,	0x0048,	/* Ḫ H */
	0x1e2b,	0x0068,	/* ḫ h */
	0x1e2c,	0x0049,	/* Ḭ I */
	0x1e2d,	0x0069,	/* ḭ i */
	0x1e2e,	0x0049,	/* Ḯ I */
	0x1e2f,	0x0069,	/* ḯ i */
	0x1e30,	0x004b,	/* Ḱ K */
	0x1e31,	0x006b,	/* ḱ k */
	0x1e32,	0x004b,	/* Ḳ K */
	0x1e33,	0x006b,	/* ḳ k */
	0x1e34,	0x004b,	/* Ḵ K */
	0x1e35,	0x006b,	/* ḵ k */
	0x1e36,	0x004c,	/* Ḷ L */
	0x1e37,	0x006c,	/* ḷ l */
	0x1e38,	0x004c,	/* Ḹ L */
	0x1e39,	0x006c,	/* ḹ l */
	0x1e3a,	0x004c,	/* Ḻ L */
	0x1e3b,	0x006c,	/* ḻ l */
	0x1e3c,	0x004c,	/* Ḽ L */
	0x1e3d,	0x006c,	/* ḽ l */
	0x1e3e,	0x004d,	/* Ḿ M */
	0x1e3f,	0x006d,	/* ḿ m */
	0x1e40,	0x004d,	/* Ṁ M */
	0x1e41,	0x006d,	/* ṁ m */
	0x1e42,	0x004d,	/* Ṃ M */
	0x1e43,	0x006d,	/* ṃ m */
	0x1e44,	0x004e,	/* Ṅ N */
	0x1e45,	0x006e,	/* ṅ n */
	0x1e46,	0x004e,	/* Ṇ N */
	0x1e47,	0x006e,	/* ṇ n */
	0x1e48,	0x004e,	/* Ṉ N */
	0x1e49,	0x006e,	/* ṉ n */
	0x1e4a,	0x004e,	/* Ṋ N */
	0x1e4b,	0x006e,	/* ṋ n */
	0x1e4c,	0x004f,	/* Ṍ O */
	0x1e4d,	0x006f,	/* ṍ o */
	0x1e4e,	0x004f,	/* Ṏ O */
	0x1e4f,	0x006f,	/* ṏ o */
	0x1e50,	0x004f,	/* Ṑ O */
	0x1e51,	0x006f,	/* ṑ o */
	0x1e52,	0x004f,	/* Ṓ O */
	0x1e53,	0x006f,	/* ṓ o */
	0x1e54,	0x0050,	/* Ṕ P */
	0x1e55,	0x0070,	/* ṕ p */
	0x1e56,	0x0050,	/* Ṗ P */
	0x1e57,	0x0070,	/* ṗ p */
	0x1e58,	0x0052,	/* Ṙ R */
	0x1e59,	0x0072,	/* ṙ r */
	0x1e5a,	0x0052,	/* Ṛ R */
	0x1e5b,	0x0072,	/* ṛ r */
	0x1e5c,	0x0052,	/* Ṝ R */
	0x1e5d,	0x0072,	/* ṝ r */
	0x1e5e,	0x0052,	/* Ṟ R */
	0x1e5f,	0x0072,	/* ṟ r */
	0x1e60,	0x0053,	/* Ṡ S */
	0x1e61,	0x0073,	/* ṡ s */
	0x1e62,	0x0053,	/* Ṣ S */
	0x1e63,	0x0073,	/* ṣ s */
	0x1e64,	0x0053,	/* Ṥ S */
	0x1e65,	0x0073,	/* ṥ s */
	0x1e66,	0x0053,	/* Ṧ S */
	0x1e67,	0x0073,	/* ṧ s */
	0x1e68,	0x0053,	/* Ṩ S */
	0x1e69,	0x0073,	/* ṩ s */
	0x1e6a,	0x0054,	/* Ṫ T */
	0x1e6b,	0x0074,	/* ṫ t */
	0x1e6c,	0x0054,	/* Ṭ T */
	0x1e6d,	0x0074,	/* ṭ t */
	0x1e6e,	0x0054,	/* Ṯ T */
	0x1e6f,	0x0074,	/* ṯ t */
	0x1e70,	0x0054,	/* Ṱ T */
	0x1e71,	0x0074,	/* ṱ t */
	0x1e72,	0x0055,	/* Ṳ U */
	0x1e73,	0x0075,	/* ṳ u */
	0x1e74,	0x0055,	/* Ṵ U */
	0x1e75,	0x0075,	/* ṵ u */
	0x1e76,	0x0055,	/* Ṷ U */
	0x1e77,	0x0075,	/* ṷ u */
	0x1e78,	0x0055,	/* Ṹ U */
	0x1e79,	0x0075,	/* ṹ u */
	0x1e7a,	0x0055,	/* Ṻ U */
	0x1e7b,	0x0075,	/* ṻ u */
	0x1e7c,	0x0056,	/* Ṽ V */
	0x1e7d,	0x0076,	/* ṽ v */
	0x1e7e,	0x0056,	/* Ṿ V */
	0x1e7f,	0x0076,	/* ṿ v */
	0x1e80,	0x0057,	/* Ẁ W */
	0x1e81,	0x0077,	/* ẁ w */
	0x1e82,	0x0057,	/* Ẃ W */
	0x1e83,	0x0077,	/* ẃ w */
	0x1e84,	0x0057,	/* Ẅ W */
	0x1e85,	0x0077,	/* ẅ w */
	0x1e86,	0x0057,	/* Ẇ W */
	0x1e87,	0x0077,	/* ẇ w */
	0x1e88,	0x0057,	/* Ẉ W */
	0x1e89,	0x0077,	/* ẉ w */
	0x1e8a,	0x0058,	/* Ẋ X */
	0x1e8b,	0x0078,	/* ẋ x */
	0x1e8c,	0x0058,	/* Ẍ X */
	0x1e8d,	0x0078,	/* ẍ x */
	0x1e8e,	0x0059,	/* Ẏ Y */
	0x1e8f,	0x0079,	/* ẏ y */
	0x1e90,	0x005a,	/* Ẑ Z */
	0x1e91,	0x007a,	/* ẑ z */
	0x1e92,	0x005a,	/* Ẓ Z */
	0x1e93,	0x007a,	/* ẓ z */
	0x1e94,	0x005a,	/* Ẕ Z */
	0x1e95,	0x007a,	/* ẕ z */
	0x1e96,	0x0068,	/* ẖ h */
	0x1e97,	0x0074,	/* ẗ t */
	0x1e98,	0x0077,	/* ẘ w */
	0x1e99,	0x0079,	/* ẙ y */
	0x1e9b,	0x017f,	/* ẛ ſ */
	0x1ea0,	0x0041,	/* Ạ A */
	0x1ea1,	0x0061,	/* ạ a */
	0x1ea2,	0x0041,	/* Ả A */
	0x1ea3,	0x0061,	/* ả a */
	0x1ea4,	0x0041,	/* Ấ A */
	0x1ea5,	0x0061,	/* ấ a */
	0x1ea6,	0x0041,	/* Ầ A */
	0x1ea7,	0x0061,	/* ầ a */
	0x1ea8,	0x0041,	/* Ẩ A */
	0x1ea9,	0x0061,	/* ẩ a */
	0x1eaa,	0x0041,	/* Ẫ A */
	0x1eab,	0x0061,	/* ẫ a */
	0x1eac,	0x0041,	/* Ậ A */
	0x1ead,	0x0061,	/* ậ a */
	0x1eae,	0x0041,	/* Ắ A */
	0x1eaf,	0x0061,	/* ắ a */
	0x1eb0,	0x0041,	/* Ằ A */
	0x1eb1,	0x0061,	/* ằ a */
	0x1eb2,	0x0041,	/* Ẳ A */
	0x1eb3,	0x0061,	/* ẳ a */
	0x1eb4,	0x0041,	/* Ẵ A */
	0x1eb5,	0x0061,	/* ẵ a */
	0x1eb6,	0x0041,	/* Ặ A */
	0x1eb7,	0x0061,	/* ặ a */
	0x1eb8,	0x0045,	/* Ẹ E */
	0x1eb9,	0x0065,	/* ẹ e */
	0x1eba,	0x0045,	/* Ẻ E */
	0x1ebb,	0x0065,	/* ẻ e */
	0x1ebc,	0x0045,	/* Ẽ E */
	0x1ebd,	0x0065,	/* ẽ e */
	0x1ebe,	0x0045,	/* Ế E */
	0x1ebf,	0x0065,	/* ế e */
	0x1ec0,	0x0045,	/* Ề E */
	0x1ec1,	0x0065,	/* ề e */
	0x1ec2,	0x0045,	/* Ể E */
	0x1ec3,	0x0065,	/* ể e */
	0x1ec4,	0x0045,	/* Ễ E */
	0x1ec5,	0x0065,	/* ễ e */
	0x1ec6,	0x0045,	/* Ệ E */
	0x1ec7,	0x0065,	/* ệ e */
	0x1ec8,	0x0049,	/* Ỉ I */
	0x1ec9,	0x0069,	/* ỉ i */
	0x1eca,	0x0049,	/* Ị I */
	0x1ecb,	0x0069,	/* ị i */
	0x1ecc,	0x004f,	/* Ọ O */
	0x1ecd,	0x006f,	/* ọ o */
	0x1ece,	0x004f,	/* Ỏ O */
	0x1ecf,	0x006f,	/* ỏ o */
	0x1ed0,	0x004f,	/* Ố O */
	0x1ed1,	0x006f,	/* ố o */
	0x1ed2,	0x004f,	/* Ồ O */
	0x1ed3,	0x006f,	/* ồ o */
	0x1ed4,	0x004f,	/* Ổ O */
	0x1ed5,	0x006f,	/* ổ o */
	0x1ed6,	0x004f,	/* Ỗ O */
	0x1ed7,	0x006f,	/* ỗ o */
	0x1ed8,	0x004f,	/* Ộ O */
	0x1ed9,	0x006f,	/* ộ o */
	0x1eda,	0x004f,	/* Ớ O */
	0x1edb,	0x006f,	/* ớ o */
	0x1edc,	0x004f,	/* Ờ O */
	0x1edd,	0x006f,	/* ờ o */
	0x1ede,	0x004f,	/* Ở O */
	0x1edf,	0x006f,	/* ở o */
	0x1ee0,	0x004f,	/* Ỡ O */
	0x1ee1,	0x006f,	/* ỡ o */
	0x1ee2,	0x004f,	/* Ợ O */
	0x1ee3,	0x006f,	/* ợ o */
	0x1ee4,	0x0055,	/* Ụ U */
	0x1ee5,	0x0075,	/* ụ u */
	0x1ee6,	0x0055,	/* Ủ U */
	0x1ee7,	0x0075,	/* ủ u */
	0x1ee8,	0x0055,	/* Ứ U */
	0x1ee9,	0x0075,	/* ứ u */
	0x1eea,	0x0055,	/* Ừ U */
	0x1eeb,	0x0075,	/* ừ u */
	0x1eec,	0x0055,	/* Ử U */
	0x1eed,	0x0075,	/* ử u */
	0x1eee,	0x0055,	/* Ữ U */
	0x1eef,	0x0075,	/* ữ u */
	0x1ef0,	0x0055,	/* Ự U */
	0x1ef1,	0x0075,	/* ự u */
	0x1ef2,	0x0059,	/* Ỳ Y */
	0x1ef3,	0x0079,	/* ỳ y */
	0x1ef4,	0x0059,	/* Ỵ Y */
	0x1ef5,	0x0079,	/* ỵ y */
	0x1ef6,	0x0059,	/* Ỷ Y */
	0x1ef7,	0x0079,	/* ỷ y */
	0x1ef8,	0x0059,	/* Ỹ Y */
	0x1ef9,	0x0079,	/* ỹ y */
	0x1f00,	0x03b1,	/* ἀ α */
	0x1f01,	0x03b1,	/* ἁ α */
	0x1f02,	0x03b1,	/* ἂ α */
	0x1f03,	0x03b1,	/* ἃ α */
	0x1f04,	0x03b1,	/* ἄ α */
	0x1f05,	0x03b1,	/* ἅ α */
	0x1f06,	0x03b1,	/* ἆ α */
	0x1f07,	0x03b1,	/* ἇ α */
	0x1f08,	0x0391,	/* Ἀ Α */
	0x1f09,	0x0391,	/* Ἁ Α */
	0x1f0a,	0x0391,	/* Ἂ Α */
	0x1f0b,	0x0391,	/* Ἃ Α */
	0x1f0c,	0x0391,	/* Ἄ Α */
	0x1f0d,	0x0391,	/* Ἅ Α */
	0x1f0e,	0x0391,	/* Ἆ Α */
	0x1f0f,	0x0391,	/* Ἇ Α */
	0x1f10,	0x03b5,	/* ἐ ε */
	0x1f11,	0x03b5,	/* ἑ ε */
	0x1f12,	0x03b5,	/* ἒ ε */
	0x1f13,	0x03b5,	/* ἓ ε */
	0x1f14,	0x03b5,	/* ἔ ε */
	0x1f15,	0x03b5,	/* ἕ ε */
	0x1f18,	0x0395,	/* Ἐ Ε */
	0x1f19,	0x0395,	/* Ἑ Ε */
	0x1f1a,	0x0395,	/* Ἒ Ε */
	0x1f1b,	0x0395,	/* Ἓ Ε */
	0x1f1c,	0x0395,	/* Ἔ Ε */
	0x1f1d,	0x0395,	/* Ἕ Ε */
	0x1f20,	0x03b7,	/* ἠ η */
	0x1f21,	0x03b7,	/* ἡ η */
	0x1f22,	0x03b7,	/* ἢ η */
	0x1f23,	0x03b7,	/* ἣ η */
	0x1f24,	0x03b7,	/* ἤ η */
	0x1f25,	0x03b7,	/* ἥ η */
	0x1f26,	0x03b7,	/* ἦ η */
	0x1f27,	0x03b7,	/* ἧ η */
	0x1f28,	0x0397,	/* Ἠ Η */
	0x1f29,	0x0397,	/* Ἡ Η */
	0x1f2a,	0x0397,	/* Ἢ Η */
	0x1f2b,	0x0397,	/* Ἣ Η */
	0x1f2c,	0x0397,	/* Ἤ Η */
	0x1f2d,	0x0397,	/* Ἥ Η */
	0x1f2e,	0x0397,	/* Ἦ Η */
	0x1f2f,	0x0397,	/* Ἧ Η */
	0x1f30,	0x03b9,	/* ἰ ι */
	0x1f31,	0x03b9,	/* ἱ ι */
	0x1f32,	0x03b9,	/* ἲ ι */
	0x1f33,	0x03b9,	/* ἳ ι */
	0x1f34,	0x03b9,	/* ἴ ι */
	0x1f35,	0x03b9,	/* ἵ ι */
	0x1f36,	0x03b9,	/* ἶ ι */
	0x1f37,	0x03b9,	/* ἷ ι */
	0x1f38,	0x0399,	/* Ἰ Ι */
	0x1f39,	0x0399,	/* Ἱ Ι */
	0x1f3a,	0x0399,	/* Ἲ Ι */
	0x1f3b,	0x0399,	/* Ἳ Ι */
	0x1f3c,	0x0399,	/* Ἴ Ι */
	0x1f3d,	0x0399,	/* Ἵ Ι */
	0x1f3e,	0x0399,	/* Ἶ Ι */
	0x1f3f,	0x0399,	/* Ἷ Ι */
	0x1f40,	0x03bf,	/* ὀ ο */
	0x1f41,	0x03bf,	/* ὁ ο */
	0x1f42,	0x03bf,	/* ὂ ο */
	0x1f43,	0x03bf,	/* ὃ ο */
	0x1f44,	0x03bf,	/* ὄ ο */
	0x1f45,	0x03bf,	/* ὅ ο */
	0x1f48,	0x039f,	/* Ὀ Ο */
	0x1f49,	0x039f,	/* Ὁ Ο */
	0x1f4a,	0x039f,	/* Ὂ Ο */
	0x1f4b,	0x039f,	/* Ὃ Ο */
	0x1f4c,	0x039f,	/* Ὄ Ο */
	0x1f4d,	0x039f,	/* Ὅ Ο */
	0x1f50,	0x03c5,	/* ὐ υ */
	0x1f51,	0x03c5,	/* ὑ υ */
	0x1f52,	0x03c5,	/* ὒ υ */
	0x1f53,	0x03c5,	/* ὓ υ */
	0x1f54,	0x03c5,	/* ὔ υ */
	0x1f55,	0x03c5,	/* ὕ υ */
	0x1f56,	0x03c5,	/* ὖ υ */
	0x1f57,	0x03c5,	/* ὗ υ */
	0x1f59,	0x03a5,	/* Ὑ Υ */
	0x1f5b,	0x03a5,	/* Ὓ Υ */
	0x1f5d,	0x03a5,	/* Ὕ Υ */
	0x1f5f,	0x03a5,	/* Ὗ Υ */
	0x1f60,	0x03c9,	/* ὠ ω */
	0x1f61,	0x03c9,	/* ὡ ω */
	0x1f62,	0x03c9,	/* ὢ ω */
	0x1f63,	0x03c9,	/* ὣ ω */
	0x1f64,	0x03c9,	/* ὤ ω */
	0x1f65,	0x03c9,	/* ὥ ω */
	0x1f66,	0x03c9,	/* ὦ ω */
	0x1f67,	0x03c9,	/* ὧ ω */
	0x1f68,	0x03a9,	/* Ὠ Ω */
	0x1f69,	0x03a9,	/* Ὡ Ω */
	0x1f6a,	0x03a9,	/* Ὢ Ω */
	0x1f6b,	0x03a9,	/* Ὣ Ω */
	0x1f6c,	0x03a9,	/* Ὤ Ω */
	0x1f6d,	0x03a9,	/* Ὥ Ω */
	0x1f6e,	0x03a9,	/* Ὦ Ω */
	0x1f6f,	0x03a9,	/* Ὧ Ω */
	0x1f70,	0x03b1,	/* ὰ α */
	0x1f71,	0x03b1,	/* ά α */
	0x1f72,	0x03b5,	/* ὲ ε */
	0x1f73,	0x03b5,	/* έ ε */
	0x1f74,	0x03b7,	/* ὴ η */
	0x1f75,	0x03b7,	/* ή η */
	0x1f76,	0x03b9,	/* ὶ ι */
	0x1f77,	0x03b9,	/* ί ι */
	0x1f78,	0x03bf,	/* ὸ ο */
	0x1f79,	0x03bf,	/* ό ο */
	0x1f7a,	0x03c5,	/* ὺ υ */
	0x1f7b,	0x03c5,	/* ύ υ */
	0x1f7c,	0x03c9,	/* ὼ ω */
	0x1f7d,	0x03c9,	/* ώ ω */
	0x1f80,	0x03b1,	/* ᾀ α */
	0x1f81,	0x03b1,	/* ᾁ α */
	0x1f82,	0x03b1,	/* ᾂ α */
	0x1f83,	0x03b1,	/* ᾃ α */
	0x1f84,	0x03b1,	/* ᾄ α */
	0x1f85,	0x03b1,	/* ᾅ α */
	0x1f86,	0x03b1,	/* ᾆ α */
	0x1f87,	0x03b1,	/* ᾇ α */
	0x1f88,	0x0391,	/* ᾈ Α */
	0x1f89,	0x0391,	/* ᾉ Α */
	0x1f8a,	0x0391,	/* ᾊ Α */
	0x1f8b,	0x0391,	/* ᾋ Α */
	0x1f8c,	0x0391,	/* ᾌ Α */
	0x1f8d,	0x0391,	/* ᾍ Α */
	0x1f8e,	0x0391,	/* ᾎ Α */
	0x1f8f,	0x0391,	/* ᾏ Α */
	0x1f90,	0x03b7,	/* ᾐ η */
	0x1f91,	0x03b7,	/* ᾑ η */
	0x1f92,	0x03b7,	/* ᾒ η */
	0x1f93,	0x03b7,	/* ᾓ η */
	0x1f94,	0x03b7,	/* ᾔ η */
	0x1f95,	0x03b7,	/* ᾕ η */
	0x1f96,	0x03b7,	/* ᾖ η */
	0x1f97,	0x03b7,	/* ᾗ η */
	0x1f98,	0x0397,	/* ᾘ Η */
	0x1f99,	0x0397,	/* ᾙ Η */
	0x1f9a,	0x0397,	/* ᾚ Η */
	0x1f9b,	0x0397,	/* ᾛ Η */
	0x1f9c,	0x0397,	/* ᾜ Η */
	0x1f9d,	0x0397,	/* ᾝ Η */
	0x1f9e,	0x0397,	/* ᾞ Η */
	0x1f9f,	0x0397,	/* ᾟ Η */
	0x1fa0,	0x03c9,	/* ᾠ ω */
	0x1fa1,	0x03c9,	/* ᾡ ω */
	0x1fa2,	0x03c9,	/* ᾢ ω */
	0x1fa3,	0x03c9,	/* ᾣ ω */
	0x1fa4,	0x03c9,	/* ᾤ ω */
	0x1fa5,	0x03c9,	/* ᾥ ω */
	0x1fa6,	0x03c9,	/* ᾦ ω */
	0x1fa7,	0x03c9,	/* ᾧ ω */
	0x1fa8,	0x03a9,	/* ᾨ Ω */
	0x1fa9,	0x03a9,	/* ᾩ Ω */
	0x1faa,	0x03a9,	/* ᾪ Ω */
	0x1fab,	0x03a9,	/* ᾫ Ω */
	0x1fac,	0x03a9,	/* ᾬ Ω */
	0x1fad,	0x03a9,	/* ᾭ Ω */
	0x1fae,	0x03a9,	/* ᾮ Ω */
	0x1faf,	0x03a9,	/* ᾯ Ω */
	0x1fb0,	0x03b1,	/* ᾰ α */
	0x1fb1,	0x03b1,	/* ᾱ α */
	0x1fb2,	0x03b1,	/* ᾲ α */
	0x1fb3,	0x03b1,	/* ᾳ α */
	0x1fb4,	0x03b1,	/* ᾴ α */
	0x1fb6,	0x03b1,	/* ᾶ α */
	0x1fb7,	0x03b1,	/* ᾷ α */
	0x1fb8,	0x0391,	/* Ᾰ Α */
	0x1fb9,	0x0391,	/* Ᾱ Α */
	0x1fba,	0x0391,	/* Ὰ Α */
	0x1fbb,	0x0391,	/* Ά Α */
	0x1fbc,	0x0391,	/* ᾼ Α */
	0x1fbe,	0x03b9,	/* ι ι */
	0x1fc2,	0x03b7,	/* ῂ η */
	0x1fc3,	0x03b7,	/* ῃ η */
	0x1fc4,	0x03b7,	/* ῄ η */
	0x1fc6,	0x03b7,	/* ῆ η */
	0x1fc7,	0x03b7,	/* ῇ η */
	0x1fc8,	0x0395,	/* Ὲ Ε */
	0x1fc9,	0x0395,	/* Έ Ε */
	0x1fca,	0x0397,	/* Ὴ Η */
	0x1fcb,	0x0397,	/* Ή Η */
	0x1fcc,	0x0397,	/* ῌ Η */
	0x1fd0,	0x03b9,	/* ῐ ι */
	0x1fd1,	0x03b9,	/* ῑ ι */
	0x1fd2,	0x03b9,	/* ῒ ι */
	0x1fd3,	0x03b9,	/* ΐ ι */
	0x1fd6,	0x03b9,	/* ῖ ι */
	0x1fd7,	0x03b9,	/* ῗ ι */
	0x1fd8,	0x0399,	/* Ῐ Ι */
	0x1fd9,	0x0399,	/* Ῑ Ι */
	0x1fda,	0x0399,	/* Ὶ Ι */
	0x1fdb,	0x0399,	/* Ί Ι */
	0x1fe0,	0x03c5,	/* ῠ υ */
	0x1fe1,	0x03c5,	/* ῡ υ */
	0x1fe2,	0x03c5,	/* ῢ υ */
	0x1fe3,	0x03c5,	/* ΰ υ */
	0x1fe4,	0x03c1,	/* ῤ ρ */
	0x1fe5,	0x03c1,	/* ῥ ρ */
	0x1fe6,	0x03c5,	/* ῦ υ */
	0x1fe7,	0x03c5,	/* ῧ υ */
	0x1fe8,	0x03a5,	/* Ῠ Υ */
	0x1fe9,	0x03a5,	/* Ῡ Υ */
	0x1fea,	0x03a5,	/* Ὺ Υ */
	0x1feb,	0x03a5,	/* Ύ Υ */
	0x1fec,	0x03a1,	/* Ῥ Ρ */
	0x1ff2,	0x03c9,	/* ῲ ω */
	0x1ff3,	0x03c9,	/* ῳ ω */
	0x1ff4,	0x03c9,	/* ῴ ω */
	0x1ff6,	0x03c9,	/* ῶ ω */
	0x1ff7,	0x03c9,	/* ῷ ω */
	0x1ff8,	0x039f,	/* Ὸ Ο */
	0x1ff9,	0x039f,	/* Ό Ο */
	0x1ffa,	0x03a9,	/* Ὼ Ω */
	0x1ffb,	0x03a9,	/* Ώ Ω */
	0x1ffc,	0x03a9,	/* ῼ Ω */
	0x2126,	0x03a9,	/* Ω Ω */
	0x212a,	0x004b,	/* K K */
	0x212b,	0x0041,	/* Å A */
	0x304c,	0x304b,	/* が か */
	0x304e,	0x304d,	/* ぎ き */
	0x3050,	0x304f,	/* ぐ く */
	0x3052,	0x3051,	/* げ け */
	0x3054,	0x3053,	/* ご こ */
	0x3056,	0x3055,	/* ざ さ */
	0x3058,	0x3057,	/* じ し */
	0x305a,	0x3059,	/* ず す */
	0x305c,	0x305b,	/* ぜ せ */
	0x305e,	0x305d,	/* ぞ そ */
	0x3060,	0x305f,	/* だ た */
	0x3062,	0x3061,	/* ぢ ち */
	0x3065,	0x3064,	/* づ つ */
	0x3067,	0x3066,	/* で て */
	0x3069,	0x3068,	/* ど と */
	0x3070,	0x306f,	/* ば は */
	0x3071,	0x306f,	/* ぱ は */
	0x3073,	0x3072,	/* び ひ */
	0x3074,	0x3072,	/* ぴ ひ */
	0x3076,	0x3075,	/* ぶ ふ */
	0x3077,	0x3075,	/* ぷ ふ */
	0x3079,	0x3078,	/* べ へ */
	0x307a,	0x3078,	/* ぺ へ */
	0x307c,	0x307b,	/* ぼ ほ */
	0x307d,	0x307b,	/* ぽ ほ */
	0x3094,	0x3046,	/* ゔ う */
	0x309e,	0x309d,	/* ゞ ゝ */
	0x30ac,	0x30ab,	/* ガ カ */
	0x30ae,	0x30ad,	/* ギ キ */
	0x30b0,	0x30af,	/* グ ク */
	0x30b2,	0x30b1,	/* ゲ ケ */
	0x30b4,	0x30b3,	/* ゴ コ */
	0x30b6,	0x30b5,	/* ザ サ */
	0x30b8,	0x30b7,	/* ジ シ */
	0x30ba,	0x30b9,	/* ズ ス */
	0x30bc,	0x30bb,	/* ゼ セ */
	0x30be,	0x30bd,	/* ゾ ソ */
	0x30c0,	0x30bf,	/* ダ タ */
	0x30c2,	0x30c1,	/* ヂ チ */
	0x30c5,	0x30c4,	/* ヅ ツ */
	0x30c7,	0x30c6,	/* デ テ */
	0x30c9,	0x30c8,	/* ド ト */
	0x30d0,	0x30cf,	/* バ ハ */
	0x30d1,	0x30cf,	/* パ ハ */
	0x30d3,	0x30d2,	/* ビ ヒ */
	0x30d4,	0x30d2,	/* ピ ヒ */
	0x30d6,	0x30d5,	/* ブ フ */
	0x30d7,	0x30d5,	/* プ フ */
	0x30d9,	0x30d8,	/* ベ ヘ */
	0x30da,	0x30d8,	/* ペ ヘ */
	0x30dc,	0x30db,	/* ボ ホ */
	0x30dd,	0x30db,	/* ポ ホ */
	0x30f4,	0x30a6,	/* ヴ ウ */
	0x30f7,	0x30ef,	/* ヷ ワ */
	0x30f8,	0x30f0,	/* ヸ ヰ */
	0x30f9,	0x30f1,	/* ヹ ヱ */
	0x30fa,	0x30f2,	/* ヺ ヲ */
	0x30fe,	0x30fd,	/* ヾ ヽ */
	0xf900,	0x8c48,	/* 豈 豈 */
	0xf901,	0x66f4,	/* 更 更 */
	0xf902,	0x8eca,	/* 車 車 */
	0xf903,	0x8cc8,	/* 賈 賈 */
	0xf904,	0x6ed1,	/* 滑 滑 */
	0xf905,	0x4e32,	/* 串 串 */
	0xf906,	0x53e5,	/* 句 句 */
	0xf907,	0x9f9c,	/* 龜 龜 */
	0xf908,	0x9f9c,	/* 龜 龜 */
	0xf909,	0x5951,	/* 契 契 */
	0xf90a,	0x91d1,	/* 金 金 */
	0xf90b,	0x5587,	/* 喇 喇 */
	0xf90c,	0x5948,	/* 奈 奈 */
	0xf90d,	0x61f6,	/* 懶 懶 */
	0xf90e,	0x7669,	/* 癩 癩 */
	0xf90f,	0x7f85,	/* 羅 羅 */
	0xf910,	0x863f,	/* 蘿 蘿 */
	0xf911,	0x87ba,	/* 螺 螺 */
	0xf912,	0x88f8,	/* 裸 裸 */
	0xf913,	0x908f,	/* 邏 邏 */
	0xf914,	0x6a02,	/* 樂 樂 */
	0xf915,	0x6d1b,	/* 洛 洛 */
	0xf916,	0x70d9,	/* 烙 烙 */
	0xf917,	0x73de,	/* 珞 珞 */
	0xf918,	0x843d,	/* 落 落 */
	0xf919,	0x916a,	/* 酪 酪 */
	0xf91a,	0x99f1,	/* 駱 駱 */
	0xf91b,	0x4e82,	/* 亂 亂 */
	0xf91c,	0x5375,	/* 卵 卵 */
	0xf91d,	0x6b04,	/* 欄 欄 */
	0xf91e,	0x721b,	/* 爛 爛 */
	0xf91f,	0x862d,	/* 蘭 蘭 */
	0xf920,	0x9e1e,	/* 鸞 鸞 */
	0xf921,	0x5d50,	/* 嵐 嵐 */
	0xf922,	0x6feb,	/* 濫 濫 */
	0xf923,	0x85cd,	/* 藍 藍 */
	0xf924,	0x8964,	/* 襤 襤 */
	0xf925,	0x62c9,	/* 拉 拉 */
	0xf926,	0x81d8,	/* 臘 臘 */
	0xf927,	0x881f,	/* 蠟 蠟 */
	0xf928,	0x5eca,	/* 廊 廊 */
	0xf929,	0x6717,	/* 朗 朗 */
	0xf92a,	0x6d6a,	/* 浪 浪 */
	0xf92b,	0x72fc,	/* 狼 狼 */
	0xf92c,	0x90ce,	/* 郎 郎 */
	0xf92d,	0x4f86,	/* 來 來 */
	0xf92e,	0x51b7,	/* 冷 冷 */
	0xf92f,	0x52de,	/* 勞 勞 */
	0xf930,	0x64c4,	/* 擄 擄 */
	0xf931,	0x6ad3,	/* 櫓 櫓 */
	0xf932,	0x7210,	/* 爐 爐 */
	0xf933,	0x76e7,	/* 盧 盧 */
	0xf934,	0x8001,	/* 老 老 */
	0xf935,	0x8606,	/* 蘆 蘆 */
	0xf936,	0x865c,	/* 虜 虜 */
	0xf937,	0x8def,	/* 路 路 */
	0xf938,	0x9732,	/* 露 露 */
	0xf939,	0x9b6f,	/* 魯 魯 */
	0xf93a,	0x9dfa,	/* 鷺 鷺 */
	0xf93b,	0x788c,	/* 碌 碌 */
	0xf93c,	0x797f,	/* 祿 祿 */
	0xf93d,	0x7da0,	/* 綠 綠 */
	0xf93e,	0x83c9,	/* 菉 菉 */
	0xf93f,	0x9304,	/* 錄 錄 */
	0xf940,	0x9e7f,	/* 鹿 鹿 */
	0xf941,	0x8ad6,	/* 論 論 */
	0xf942,	0x58df,	/* 壟 壟 */
	0xf943,	0x5f04,	/* 弄 弄 */
	0xf944,	0x7c60,	/* 籠 籠 */
	0xf945,	0x807e,	/* 聾 聾 */
	0xf946,	0x7262,	/* 牢 牢 */
	0xf947,	0x78ca,	/* 磊 磊 */
	0xf948,	0x8cc2,	/* 賂 賂 */
	0xf949,	0x96f7,	/* 雷 雷 */
	0xf94a,	0x58d8,	/* 壘 壘 */
	0xf94b,	0x5c62,	/* 屢 屢 */
	0xf94c,	0x6a13,	/* 樓 樓 */
	0xf94d,	0x6dda,	/* 淚 淚 */
	0xf94e,	0x6f0f,	/* 漏 漏 */
	0xf94f,	0x7d2f,	/* 累 累 */
	0xf950,	0x7e37,	/* 縷 縷 */
	0xf951,	0x964b,	/* 陋 陋 */
	0xf952,	0x52d2,	/* 勒 勒 */
	0xf953,	0x808b,	/* 肋 肋 */
	0xf954,	0x51dc,	/* 凜 凜 */
	0xf955,	0x51cc,	/* 凌 凌 */
	0xf956,	0x7a1c,	/* 稜 稜 */
	0xf957,	0x7dbe,	/* 綾 綾 */
	0xf958,	0x83f1,	/* 菱 菱 */
	0xf959,	0x9675,	/* 陵 陵 */
	0xf95a,	0x8b80,	/* 讀 讀 */
	0xf95b,	0x62cf,	/* 拏 拏 */
	0xf95c,	0x6a02,	/* 樂 樂 */
	0xf95d,	0x8afe,	/* 諾 諾 */
	0xf95e,	0x4e39,	/* 丹 丹 */
	0xf95f,	0x5be7,	/* 寧 寧 */
	0xf960,	0x6012,	/* 怒 怒 */
	0xf961,	0x7387,	/* 率 率 */
	0xf962,	0x7570,	/* 異 異 */
	0xf963,	0x5317,	/* 北 北 */
	0xf964,	0x78fb,	/* 磻 磻 */
	0xf965,	0x4fbf,	/* 便 便 */
	0xf966,	0x5fa9,	/* 復 復 */
	0xf967,	0x4e0d,	/* 不 不 */
	0xf968,	0x6ccc,	/* 泌 泌 */
	0xf969,	0x6578,	/* 數 數 */
	0xf96a,	0x7d22,	/* 索 索 */
	0xf96b,	0x53c3,	/* 參 參 */
	0xf96c,	0x585e,	/* 塞 塞 */
	0xf96d,	0x7701,	/* 省 省 */
	0xf96e,	0x8449,	/* 葉 葉 */
	0xf96f,	0x8aaa,	/* 說 說 */
	0xf970,	0x6bba,	/* 殺 殺 */
	0xf971,	0x8fb0,	/* 辰 辰 */
	0xf972,	0x6c88,	/* 沈 沈 */
	0xf973,	0x62fe,	/* 拾 拾 */
	0xf974,	0x82e5,	/* 若 若 */
	0xf975,	0x63a0,	/* 掠 掠 */
	0xf976,	0x7565,	/* 略 略 */
	0xf977,	0x4eae,	/* 亮 亮 */
	0xf978,	0x5169,	/* 兩 兩 */
	0xf979,	0x51c9,	/* 凉 凉 */
	0xf97a,	0x6881,	/* 梁 梁 */
	0xf97b,	0x7ce7,	/* 糧 糧 */
	0xf97c,	0x826f,	/* 良 良 */
	0xf97d,	0x8ad2,	/* 諒 諒 */
	0xf97e,	0x91cf,	/* 量 量 */
	0xf97f,	0x52f5,	/* 勵 勵 */
	0xf980,	0x5442,	/* 呂 呂 */
	0xf981,	0x5973,	/* 女 女 */
	0xf982,	0x5eec,	/* 廬 廬 */
	0xf983,	0x65c5,	/* 旅 旅 */
	0xf984,	0x6ffe,	/* 濾 濾 */
	0xf985,	0x792a,	/* 礪 礪 */
	0xf986,	0x95ad,	/* 閭 閭 */
	0xf987,	0x9a6a,	/* 驪 驪 */
	0xf988,	0x9e97,	/* 麗 麗 */
	0xf989,	0x9ece,	/* 黎 黎 */
	0xf98a,	0x529b,	/* 力 力 */
	0xf98b,	0x66c6,	/* 曆 曆 */
	0xf98c,	0x6b77,	/* 歷 歷 */
	0xf98d,	0x8f62,	/* 轢 轢 */
	0xf98e,	0x5e74,	/* 年 年 */
	0xf98f,	0x6190,	/* 憐 憐 */
	0xf990,	0x6200,	/* 戀 戀 */
	0xf991,	0x649a,	/* 撚 撚 */
	0xf992,	0x6f23,	/* 漣 漣 */
	0xf993,	0x7149,	/* 煉 煉 */
	0xf994,	0x7489,	/* 璉 璉 */
	0xf995,	0x79ca,	/* 秊 秊 */
	0xf996,	0x7df4,	/* 練 練 */
	0xf997,	0x806f,	/* 聯 聯 */
	0xf998,	0x8f26,	/* 輦 輦 */
	0xf999,	0x84ee,	/* 蓮 蓮 */
	0xf99a,	0x9023,	/* 連 連 */
	0xf99b,	0x934a,	/* 鍊 鍊 */
	0xf99c,	0x5217,	/* 列 列 */
	0xf99d,	0x52a3,	/* 劣 劣 */
	0xf99e,	0x54bd,	/* 咽 咽 */
	0xf99f,	0x70c8,	/* 烈 烈 */
	0xf9a0,	0x88c2,	/* 裂 裂 */
	0xf9a1,	0x8aaa,	/* 說 說 */
	0xf9a2,	0x5ec9,	/* 廉 廉 */
	0xf9a3,	0x5ff5,	/* 念 念 */
	0xf9a4,	0x637b,	/* 捻 捻 */
	0xf9a5,	0x6bae,	/* 殮 殮 */
	0xf9a6,	0x7c3e,	/* 簾 簾 */
	0xf9a7,	0x7375,	/* 獵 獵 */
	0xf9a8,	0x4ee4,	/* 令 令 */
	0xf9a9,	0x56f9,	/* 囹 囹 */
	0xf9aa,	0x5be7,	/* 寧 寧 */
	0xf9ab,	0x5dba,	/* 嶺 嶺 */
	0xf9ac,	0x601c,	/* 怜 怜 */
	0xf9ad,	0x73b2,	/* 玲 玲 */
	0xf9ae,	0x7469,	/* 瑩 瑩 */
	0xf9af,	0x7f9a,	/* 羚 羚 */
	0xf9b0,	0x8046,	/* 聆 聆 */
	0xf9b1,	0x9234,	/* 鈴 鈴 */
	0xf9b2,	0x96f6,	/* 零 零 */
	0xf9b3,	0x9748,	/* 靈 靈 */
	0xf9b4,	0x9818,	/* 領 領 */
	0xf9b5,	0x4f8b,	/* 例 例 */
	0xf9b6,	0x79ae,	/* 禮 禮 */
	0xf9b7,	0x91b4,	/* 醴 醴 */
	0xf9b8,	0x96b8,	/* 隸 隸 */
	0xf9b9,	0x60e1,	/* 惡 惡 */
	0xf9ba,	0x4e86,	/* 了 了 */
	0xf9bb,	0x50da,	/* 僚 僚 */
	0xf9bc,	0x5bee,	/* 寮 寮 */
	0xf9bd,	0x5c3f,	/* 尿 尿 */
	0xf9be,	0x6599,	/* 料 料 */
	0xf9bf,	0x6a02,	/* 樂 樂 */
	0xf9c0,	0x71ce,	/* 燎 燎 */
	0xf9c1,	0x7642,	/* 療 療 */
	0xf9c2,	0x84fc,	/* 蓼 蓼 */
	0xf9c3,	0x907c,	/* 遼 遼 */
	0xf9c4,	0x9f8d,	/* 龍 龍 */
	0xf9c5,	0x6688,	/* 暈 暈 */
	0xf9c6,	0x962e,	/* 阮 阮 */
	0xf9c7,	0x5289,	/* 劉 劉 */
	0xf9c8,	0x677b,	/* 杻 杻 */
	0xf9c9,	0x67f3,	/* 柳 柳 */
	0xf9ca,	0x6d41,	/* 流 流 */
	0xf9cb,	0x6e9c,	/* 溜 溜 */
	0xf9cc,	0x7409,	/* 琉 琉 */
	0xf9cd,	0x7559,	/* 留 留 */
	0xf9ce,	0x786b,	/* 硫 硫 */
	0xf9cf,	0x7d10,	/* 紐 紐 */
	0xf9d0,	0x985e,	/* 類 類 */
	0xf9d1,	0x516d,	/* 六 六 */
	0xf9d2,	0x622e,	/* 戮 戮 */
	0xf9d3,	0x9678,	/* 陸 陸 */
	0xf9d4,	0x502b,	/* 倫 倫 */
	0xf9d5,	0x5d19,	/* 崙 崙 */
	0xf9d6,	0x6dea,	/* 淪 淪 */
	0xf9d7,	0x8f2a,	/* 輪 輪 */
	0xf9d8,	0x5f8b,	/* 律 律 */
	0xf9d9,	0x6144,	/* 慄 慄 */
	0xf9da,	0x6817,	/* 栗 栗 */
	0xf9db,	0x7387,	/* 率 率 */
	0xf9dc,	0x9686,	/* 隆 隆 */
	0xf9dd,	0x5229,	/* 利 利 */
	0xf9de,	0x540f,	/* 吏 吏 */
	0xf9df,	0x5c65,	/* 履 履 */
	0xf9e0,	0x6613,	/* 易 易 */
	0xf9e1,	0x674e,	/* 李 李 */
	0xf9e2,	0x68a8,	/* 梨 梨 */
	0xf9e3,	0x6ce5,	/* 泥 泥 */
	0xf9e4,	0x7406,	/* 理 理 */
	0xf9e5,	0x75e2,	/* 痢 痢 */
	0xf9e6,	0x7f79,	/* 罹 罹 */
	0xf9e7,	0x88cf,	/* 裏 裏 */
	0xf9e8,	0x88e1,	/* 裡 裡 */
	0xf9e9,	0x91cc,	/* 里 里 */
	0xf9ea,	0x96e2,	/* 離 離 */
	0xf9eb,	0x533f,	/* 匿 匿 */
	0xf9ec,	0x6eba,	/* 溺 溺 */
	0xf9ed,	0x541d,	/* 吝 吝 */
	0xf9ee,	0x71d0,	/* 燐 燐 */
	0xf9ef,	0x7498,	/* 璘 璘 */
	0xf9f0,	0x85fa,	/* 藺 藺 */
	0xf9f1,	0x96a3,	/* 隣 隣 */
	0xf9f2,	0x9c57,	/* 鱗 鱗 */
	0xf9f3,	0x9e9f,	/* 麟 麟 */
	0xf9f4,	0x6797,	/* 林 林 */
	0xf9f5,	0x6dcb,	/* 淋 淋 */
	0xf9f6,	0x81e8,	/* 臨 臨 */
	0xf9f7,	0x7acb,	/* 立 立 */
	0xf9f8,	0x7b20,	/* 笠 笠 */
	0xf9f9,	0x7c92,	/* 粒 粒 */
	0xf9fa,	0x72c0,	/* 狀 狀 */
	0xf9fb,	0x7099,	/* 炙 炙 */
	0xf9fc,	0x8b58,	/* 識 識 */
	0xf9fd,	0x4ec0,	/* 什 什 */
	0xf9fe,	0x8336,	/* 茶 茶 */
	0xf9ff,	0x523a,	/* 刺 刺 */
	0xfa00,	0x5207,	/* 切 切 */
	0xfa01,	0x5ea6,	/* 度 度 */
	0xfa02,	0x62d3,	/* 拓 拓 */
	0xfa03,	0x7cd6,	/* 糖 糖 */
	0xfa04,	0x5b85,	/* 宅 宅 */
	0xfa05,	0x6d1e,	/* 洞 洞 */
	0xfa06,	0x66b4,	/* 暴 暴 */
	0xfa07,	0x8f3b,	/* 輻 輻 */
	0xfa08,	0x884c,	/* 行 行 */
	0xfa09,	0x964d,	/* 降 降 */
	0xfa0a,	0x898b,	/* 見 見 */
	0xfa0b,	0x5ed3,	/* 廓 廓 */
	0xfa0c,	0x5140,	/* 兀 兀 */
	0xfa0d,	0x55c0,	/* 嗀 嗀 */
	0xfa10,	0x585a,	/* 塚 塚 */
	0xfa12,	0x6674,	/* 晴 晴 */
	0xfa15,	0x51de,	/* 凞 凞 */
	0xfa16,	0x732a,	/* 猪 猪 */
	0xfa17,	0x76ca,	/* 益 益 */
	0xfa18,	0x793c,	/* 礼 礼 */
	0xfa19,	0x795e,	/* 神 神 */
	0xfa1a,	0x7965,	/* 祥 祥 */
	0xfa1b,	0x798f,	/* 福 福 */
	0xfa1c,	0x9756,	/* 靖 靖 */
	0xfa1d,	0x7cbe,	/* 精 精 */
	0xfa1e,	0x7fbd,	/* 羽 羽 */
	0xfa20,	0x8612,	/* 蘒 蘒 */
	0xfa22,	0x8af8,	/* 諸 諸 */
	0xfa25,	0x9038,	/* 逸 逸 */
	0xfa26,	0x90fd,	/* 都 都 */
	0xfa2a,	0x98ef,	/* 飯 飯 */
	0xfa2b,	0x98fc,	/* 飼 飼 */
	0xfa2c,	0x9928,	/* 館 館 */
	0xfa2d,	0x9db4,	/* 鶴 鶴 */
	0xfa2e,	0x90de,	/* 郞 郞 */
	0xfa2f,	0x96b7,	/* 隷 隷 */
	0xfa30,	0x4fae,	/* 侮 侮 */
	0xfa31,	0x50e7,	/* 僧 僧 */
	0xfa32,	0x514d,	/* 免 免 */
	0xfa33,	0x52c9,	/* 勉 勉 */
	0xfa34,	0x52e4,	/* 勤 勤 */
	0xfa35,	0x5351,	/* 卑 卑 */
	0xfa36,	0x559d,	/* 喝 喝 */
	0xfa37,	0x5606,	/* 嘆 嘆 */
	0xfa38,	0x5668,	/* 器 器 */
	0xfa39,	0x5840,	/* 塀 塀 */
	0xfa3a,	0x58a8,	/* 墨 墨 */
	0xfa3b,	0x5c64,	/* 層 層 */
	0xfa3c,	0x5c6e,	/* 屮 屮 */
	0xfa3d,	0x6094,	/* 悔 悔 */
	0xfa3e,	0x6168,	/* 慨 慨 */
	0xfa3f,	0x618e,	/* 憎 憎 */
	0xfa40,	0x61f2,	/* 懲 懲 */
	0xfa41,	0x654f,	/* 敏 敏 */
	0xfa42,	0x65e2,	/* 既 既 */
	0xfa43,	0x6691,	/* 暑 暑 */
	0xfa44,	0x6885,	/* 梅 梅 */
	0xfa45,	0x6d77,	/* 海 海 */
	0xfa46,	0x6e1a,	/* 渚 渚 */
	0xfa47,	0x6f22,	/* 漢 漢 */
	0xfa48,	0x716e,	/* 煮 煮 */
	0xfa49,	0x722b,	/* 爫 爫 */
	0xfa4a,	0x7422,	/* 琢 琢 */
	0xfa4b,	0x7891,	/* 碑 碑 */
	0xfa4c,	0x793e,	/* 社 社 */
	0xfa4d,	0x7949,	/* 祉 祉 */
	0xfa4e,	0x7948,	/* 祈 祈 */
	0xfa4f,	0x7950,	/* 祐 祐 */
	0xfa50,	0x7956,	/* 祖 祖 */
	0xfa51,	0x795d,	/* 祝 祝 */
	0xfa52,	0x798d,	/* 禍 禍 */
	0xfa53,	0x798e,	/* 禎 禎 */
	0xfa54,	0x7a40,	/* 穀 穀 */
	0xfa55,	0x7a81,	/* 突 突 */
	0xfa56,	0x7bc0,	/* 節 節 */
	0xfa57,	0x7df4,	/* 練 練 */
	0xfa58,	0x7e09,	/* 縉 縉 */
	0xfa59,	0x7e41,	/* 繁 繁 */
	0xfa5a,	0x7f72,	/* 署 署 */
	0xfa5b,	0x8005,	/* 者 者 */
	0xfa5c,	0x81ed,	/* 臭 臭 */
	0xfa5d,	0x8279,	/* 艹 艹 */
	0xfa5e,	0x8279,	/* 艹 艹 */
	0xfa5f,	0x8457,	/* 著 著 */
	0xfa60,	0x8910,	/* 褐 褐 */
	0xfa61,	0x8996,	/* 視 視 */
	0xfa62,	0x8b01,	/* 謁 謁 */
	0xfa63,	0x8b39,	/* 謹 謹 */
	0xfa64,	0x8cd3,	/* 賓 賓 */
	0xfa65,	0x8d08,	/* 贈 贈 */
	0xfa66,	0x8fb6,	/* 辶 辶 */
	0xfa67,	0x9038,	/* 逸 逸 */
	0xfa68,	0x96e3,	/* 難 難 */
	0xfa69,	0x97ff,	/* 響 響 */
	0xfa6a,	0x983b,	/* 頻 頻 */
	0xfa6b,	0x6075,	/* 恵 恵 */
	0xfa6c,	0x242ee,	/* 𤋮 𤋮 */
	0xfa6d,	0x8218,	/* 舘 舘 */
	0xfa70,	0x4e26,	/* 並 並 */
	0xfa71,	0x51b5,	/* 况 况 */
	0xfa72,	0x5168,	/* 全 全 */
	0xfa73,	0x4f80,	/* 侀 侀 */
	0xfa74,	0x5145,	/* 充 充 */
	0xfa75,	0x5180,	/* 冀 冀 */
	0xfa76,	0x52c7,	/* 勇 勇 */
	0xfa77,	0x52fa,	/* 勺 勺 */
	0xfa78,	0x559d,	/* 喝 喝 */
	0xfa79,	0x5555,	/* 啕 啕 */
	0xfa7a,	0x5599,	/* 喙 喙 */
	0xfa7b,	0x55e2,	/* 嗢 嗢 */
	0xfa7c,	0x585a,	/* 塚 塚 */
	0xfa7d,	0x58b3,	/* 墳 墳 */
	0xfa7e,	0x5944,	/* 奄 奄 */
	0xfa7f,	0x5954,	/* 奔 奔 */
	0xfa80,	0x5a62,	/* 婢 婢 */
	0xfa81,	0x5b28,	/* 嬨 嬨 */
	0xfa82,	0x5ed2,	/* 廒 廒 */
	0xfa83,	0x5ed9,	/* 廙 廙 */
	0xfa84,	0x5f69,	/* 彩 彩 */
	0xfa85,	0x5fad,	/* 徭 徭 */
	0xfa86,	0x60d8,	/* 惘 惘 */
	0xfa87,	0x614e,	/* 慎 慎 */
	0xfa88,	0x6108,	/* 愈 愈 */
	0xfa89,	0x618e,	/* 憎 憎 */
	0xfa8a,	0x6160,	/* 慠 慠 */
	0xfa8b,	0x61f2,	/* 懲 懲 */
	0xfa8c,	0x6234,	/* 戴 戴 */
	0xfa8d,	0x63c4,	/* 揄 揄 */
	0xfa8e,	0x641c,	/* 搜 搜 */
	0xfa8f,	0x6452,	/* 摒 摒 */
	0xfa90,	0x6556,	/* 敖 敖 */
	0xfa91,	0x6674,	/* 晴 晴 */
	0xfa92,	0x6717,	/* 朗 朗 */
	0xfa93,	0x671b,	/* 望 望 */
	0xfa94,	0x6756,	/* 杖 杖 */
	0xfa95,	0x6b79,	/* 歹 歹 */
	0xfa96,	0x6bba,	/* 殺 殺 */
	0xfa97,	0x6d41,	/* 流 流 */
	0xfa98,	0x6edb,	/* 滛 滛 */
	0xfa99,	0x6ecb,	/* 滋 滋 */
	0xfa9a,	0x6f22,	/* 漢 漢 */
	0xfa9b,	0x701e,	/* 瀞 瀞 */
	0xfa9c,	0x716e,	/* 煮 煮 */
	0xfa9d,	0x77a7,	/* 瞧 瞧 */
	0xfa9e,	0x7235,	/* 爵 爵 */
	0xfa9f,	0x72af,	/* 犯 犯 */
	0xfaa0,	0x732a,	/* 猪 猪 */
	0xfaa1,	0x7471,	/* 瑱 瑱 */
	0xfaa2,	0x7506,	/* 甆 甆 */
	0xfaa3,	0x753b,	/* 画 画 */
	0xfaa4,	0x761d,	/* 瘝 瘝 */
	0xfaa5,	0x761f,	/* 瘟 瘟 */
	0xfaa6,	0x76ca,	/* 益 益 */
	0xfaa7,	0x76db,	/* 盛 盛 */
	0xfaa8,	0x76f4,	/* 直 直 */
	0xfaa9,	0x774a,	/* 睊 睊 */
	0xfaaa,	0x7740,	/* 着 着 */
	0xfaab,	0x78cc,	/* 磌 磌 */
	0xfaac,	0x7ab1,	/* 窱 窱 */
	0xfaad,	0x7bc0,	/* 節 節 */
	0xfaae,	0x7c7b,	/* 类 类 */
	0xfaaf,	0x7d5b,	/* 絛 絛 */
	0xfab0,	0x7df4,	/* 練 練 */
	0xfab1,	0x7f3e,	/* 缾 缾 */
	0xfab2,	0x8005,	/* 者 者 */
	0xfab3,	0x8352,	/* 荒 荒 */
	0xfab4,	0x83ef,	/* 華 華 */
	0xfab5,	0x8779,	/* 蝹 蝹 */
	0xfab6,	0x8941,	/* 襁 襁 */
	0xfab7,	0x8986,	/* 覆 覆 */
	0xfab8,	0x8996,	/* 視 視 */
	0xfab9,	0x8abf,	/* 調 調 */
	0xfaba,	0x8af8,	/* 諸 諸 */
	0xfabb,	0x8acb,	/* 請 請 */
	0xfabc,	0x8b01,	/* 謁 謁 */
	0xfabd,	0x8afe,	/* 諾 諾 */
	0xfabe,	0x8aed,	/* 諭 諭 */
	0xfabf,	0x8b39,	/* 謹 謹 */
	0xfac0,	0x8b8a,	/* 變 變 */
	0xfac1,	0x8d08,	/* 贈 贈 */
	0xfac2,	0x8f38,	/* 輸 輸 */
	0xfac3,	0x9072,	/* 遲 遲 */
	0xfac4,	0x9199,	/* 醙 醙 */
	0xfac5,	0x9276,	/* 鉶 鉶 */
	0xfac6,	0x967c,	/* 陼 陼 */
	0xfac7,	0x96e3,	/* 難 難 */
	0xfac8,	0x9756,	/* 靖 靖 */
	0xfac9,	0x97db,	/* 韛 韛 */
	0xfaca,	0x97ff,	/* 響 響 */
	0xfacb,	0x980b,	/* 頋 頋 */
	0xfacc,	0x983b,	/* 頻 頻 */
	0xfacd,	0x9b12,	/* 鬒 鬒 */
	0xface,	0x9f9c,	/* 龜 龜 */
	0xfacf,	0x2284a,	/* 𢡊 𢡊 */
	0xfad0,	0x22844,	/* 𢡄 𢡄 */
	0xfad1,	0x233d5,	/* 𣏕 𣏕 */
	0xfad2,	0x3b9d,	/* 㮝 㮝 */
	0xfad3,	0x4018,	/* 䀘 䀘 */
	0xfad4,	0x4039,	/* 䀹 䀹 */
	0xfad5,	0x25249,	/* 𥉉 𥉉 */
	0xfad6,	0x25cd0,	/* 𥳐 𥳐 */
	0xfad7,	0x27ed3,	/* 𧻓 𧻓 */
	0xfad8,	0x9f43,	/* 齃 齃 */
	0xfad9,	0x9f8e,	/* 龎 龎 */
	0xfb1d,	0x05d9,	/* יִ י */
	0xfb1f,	0x05f2,	/* ײַ ײ */
	0xfb2a,	0x05e9,	/* שׁ ש */
	0xfb2b,	0x05e9,	/* שׂ ש */
	0xfb2c,	0x05e9,	/* שּׁ ש */
	0xfb2d,	0x05e9,	/* שּׂ ש */
	0xfb2e,	0x05d0,	/* אַ א */
	0xfb2f,	0x05d0,	/* אָ א */
	0xfb30,	0x05d0,	/* אּ א */
	0xfb31,	0x05d1,	/* בּ ב */
	0xfb32,	0x05d2,	/* גּ ג */
	0xfb33,	0x05d3,	/* דּ ד */
	0xfb34,	0x05d4,	/* הּ ה */
	0xfb35,	0x05d5,	/* וּ ו */
	0xfb36,	0x05d6,	/* זּ ז */
	0xfb38,	0x05d8,	/* טּ ט */
	0xfb39,	0x05d9,	/* יּ י */
	0xfb3a,	0x05da,	/* ךּ ך */
	0xfb3b,	0x05db,	/* כּ כ */
	0xfb3c,	0x05dc,	/* לּ ל */
	0xfb3e,	0x05de,	/* מּ מ */
	0xfb40,	0x05e0,	/* נּ נ */
	0xfb41,	0x05e1,	/* סּ ס */
	0xfb43,	0x05e3,	/* ףּ ף */
	0xfb44,	0x05e4,	/* פּ פ */
	0xfb46,	0x05e6,	/* צּ צ */
	0xfb47,	0x05e7,	/* קּ ק */
	0xfb48,	0x05e8,	/* רּ ר */
	0xfb49,	0x05e9,	/* שּ ש */
	0xfb4a,	0x05ea,	/* תּ ת */
	0xfb4b,	0x05d5,	/* וֹ ו */
	0xfb4c,	0x05d1,	/* בֿ ב */
	0xfb4d,	0x05db,	/* כֿ כ */
	0xfb4e,	0x05e4,	/* פֿ פ */
	0x1109a,	0x11099,	/* 𑂚 𑂙 */
	0x1109c,	0x1109b,	/* 𑂜 𑂛 */
	0x110ab,	0x110a5,	/* 𑂫 𑂥 */
	0x2f800,	0x4e3d,	/* 丽 丽 */
	0x2f801,	0x4e38,	/* 丸 丸 */
	0x2f802,	0x4e41,	/* 乁 乁 */
	0x2f803,	0x20122,	/* 𠄢 𠄢 */
	0x2f804,	0x4f60,	/* 你 你 */
	0x2f805,	0x4fae,	/* 侮 侮 */
	0x2f806,	0x4fbb,	/* 侻 侻 */
	0x2f807,	0x5002,	/* 倂 倂 */
	0x2f808,	0x507a,	/* 偺 偺 */
	0x2f809,	0x5099,	/* 備 備 */
	0x2f80a,	0x50e7,	/* 僧 僧 */
	0x2f80b,	0x50cf,	/* 像 像 */
	0x2f80c,	0x349e,	/* 㒞 㒞 */
	0x2f80d,	0x2063a,	/* 𠘺 𠘺 */
	0x2f80e,	0x514d,	/* 免 免 */
	0x2f80f,	0x5154,	/* 兔 兔 */
	0x2f810,	0x5164,	/* 兤 兤 */
	0x2f811,	0x5177,	/* 具 具 */
	0x2f812,	0x2051c,	/* 𠔜 𠔜 */
	0x2f813,	0x34b9,	/* 㒹 㒹 */
	0x2f814,	0x5167,	/* 內 內 */
	0x2f815,	0x518d,	/* 再 再 */
	0x2f816,	0x2054b,	/* 𠕋 𠕋 */
	0x2f817,	0x5197,	/* 冗 冗 */
	0x2f818,	0x51a4,	/* 冤 冤 */
	0x2f819,	0x4ecc,	/* 仌 仌 */
	0x2f81a,	0x51ac,	/* 冬 冬 */
	0x2f81b,	0x51b5,	/* 况 况 */
	0x2f81c,	0x291df,	/* 𩇟 𩇟 */
	0x2f81d,	0x51f5,	/* 凵 凵 */
	0x2f81e,	0x5203,	/* 刃 刃 */
	0x2f81f,	0x34df,	/* 㓟 㓟 */
	0x2f820,	0x523b,	/* 刻 刻 */
	0x2f821,	0x5246,	/* 剆 剆 */
	0x2f822,	0x5272,	/* 割 割 */
	0x2f823,	0x5277,	/* 剷 剷 */
	0x2f824,	0x3515,	/* 㔕 㔕 */
	0x2f825,	0x52c7,	/* 勇 勇 */
	0x2f826,	0x52c9,	/* 勉 勉 */
	0x2f827,	0x52e4,	/* 勤 勤 */
	0x2f828,	0x52fa,	/* 勺 勺 */
	0x2f829,	0x5305,	/* 包 包 */
	0x2f82a,	0x5306,	/* 匆 匆 */
	0x2f82b,	0x5317,	/* 北 北 */
	0x2f82c,	0x5349,	/* 卉 卉 */
	0x2f82d,	0x5351,	/* 卑 卑 */
	0x2f82e,	0x535a,	/* 博 博 */
	0x2f82f,	0x5373,	/* 即 即 */
	0x2f830,	0x537d,	/* 卽 卽 */
	0x2f831,	0x537f,	/* 卿 卿 */
	0x2f832,	0x537f,	/* 卿 卿 */
	0x2f833,	0x537f,	/* 卿 卿 */
	0x2f834,	0x20a2c,	/* 𠨬 𠨬 */
	0x2f835,	0x7070,	/* 灰 灰 */
	0x2f836,	0x53ca,	/* 及 及 */
	0x2f837,	0x53df,	/* 叟 叟 */
	0x2f838,	0x20b63,	/* 𠭣 𠭣 */
	0x2f839,	0x53eb,	/* 叫 叫 */
	0x2f83a,	0x53f1,	/* 叱 叱 */
	0x2f83b,	0x5406,	/* 吆 吆 */
	0x2f83c,	0x549e,	/* 咞 咞 */
	0x2f83d,	0x5438,	/* 吸 吸 */
	0x2f83e,	0x5448,	/* 呈 呈 */
	0x2f83f,	0x5468,	/* 周 周 */
	0x2f840,	0x54a2,	/* 咢 咢 */
	0x2f841,	0x54f6,	/* 哶 哶 */
	0x2f842,	0x5510,	/* 唐 唐 */
	0x2f843,	0x5553,	/* 啓 啓 */
	0x2f844,	0x5563,	/* 啣 啣 */
	0x2f845,	0x5584,	/* 善 善 */
	0x2f846,	0x5584,	/* 善 善 */
	0x2f847,	0x5599,	/* 喙 喙 */
	0x2f848,	0x55ab,	/* 喫 喫 */
	0x2f849,	0x55b3,	/* 喳 喳 */
	0x2f84a,	0x55c2,	/* 嗂 嗂 */
	0x2f84b,	0x5716,	/* 圖 圖 */
	0x2f84c,	0x5606,	/* 嘆 嘆 */
	0x2f84d,	0x5717,	/* 圗 圗 */
	0x2f84e,	0x5651,	/* 噑 噑 */
	0x2f84f,	0x5674,	/* 噴 噴 */
	0x2f850,	0x5207,	/* 切 切 */
	0x2f851,	0x58ee,	/* 壮 壮 */
	0x2f852,	0x57ce,	/* 城 城 */
	0x2f853,	0x57f4,	/* 埴 埴 */
	0x2f854,	0x580d,	/* 堍 堍 */
	0x2f855,	0x578b,	/* 型 型 */
	0x2f856,	0x5832,	/* 堲 堲 */
	0x2f857,	0x5831,	/* 報 報 */
	0x2f858,	0x58ac,	/* 墬 墬 */
	0x2f859,	0x214e4,	/* 𡓤 𡓤 */
	0x2f85a,	0x58f2,	/* 売 売 */
	0x2f85b,	0x58f7,	/* 壷 壷 */
	0x2f85c,	0x5906,	/* 夆 夆 */
	0x2f85d,	0x591a,	/* 多 多 */
	0x2f85e,	0x5922,	/* 夢 夢 */
	0x2f85f,	0x5962,	/* 奢 奢 */
	0x2f860,	0x216a8,	/* 𡚨 𡚨 */
	0x2f861,	0x216ea,	/* 𡛪 𡛪 */
	0x2f862,	0x59ec,	/* 姬 姬 */
	0x2f863,	0x5a1b,	/* 娛 娛 */
	0x2f864,	0x5a27,	/* 娧 娧 */
	0x2f865,	0x59d8,	/* 姘 姘 */
	0x2f866,	0x5a66,	/* 婦 婦 */
	0x2f867,	0x36ee,	/* 㛮 㛮 */
	0x2f868,	0x36fc,	/* 㛼 㛼 */
	0x2f869,	0x5b08,	/* 嬈 嬈 */
	0x2f86a,	0x5b3e,	/* 嬾 嬾 */
	0x2f86b,	0x5b3e,	/* 嬾 嬾 */
	0x2f86c,	0x219c8,	/* 𡧈 𡧈 */
	0x2f86d,	0x5bc3,	/* 寃 寃 */
	0x2f86e,	0x5bd8,	/* 寘 寘 */
	0x2f86f,	0x5be7,	/* 寧 寧 */
	0x2f870,	0x5bf3,	/* 寳 寳 */
	0x2f871,	0x21b18,	/* 𡬘 𡬘 */
	0x2f872,	0x5bff,	/* 寿 寿 */
	0x2f873,	0x5c06,	/* 将 将 */
	0x2f874,	0x5f53,	/* 当 当 */
	0x2f875,	0x5c22,	/* 尢 尢 */
	0x2f876,	0x3781,	/* 㞁 㞁 */
	0x2f877,	0x5c60,	/* 屠 屠 */
	0x2f878,	0x5c6e,	/* 屮 屮 */
	0x2f879,	0x5cc0,	/* 峀 峀 */
	0x2f87a,	0x5c8d,	/* 岍 岍 */
	0x2f87b,	0x21de4,	/* 𡷤 𡷤 */
	0x2f87c,	0x5d43,	/* 嵃 嵃 */
	0x2f87d,	0x21de6,	/* 𡷦 𡷦 */
	0x2f87e,	0x5d6e,	/* 嵮 嵮 */
	0x2f87f,	0x5d6b,	/* 嵫 嵫 */
	0x2f880,	0x5d7c,	/* 嵼 嵼 */
	0x2f881,	0x5de1,	/* 巡 巡 */
	0x2f882,	0x5de2,	/* 巢 巢 */
	0x2f883,	0x382f,	/* 㠯 㠯 */
	0x2f884,	0x5dfd,	/* 巽 巽 */
	0x2f885,	0x5e28,	/* 帨 帨 */
	0x2f886,	0x5e3d,	/* 帽 帽 */
	0x2f887,	0x5e69,	/* 幩 幩 */
	0x2f888,	0x3862,	/* 㡢 㡢 */
	0x2f889,	0x22183,	/* 𢆃 𢆃 */
	0x2f88a,	0x387c,	/* 㡼 㡼 */
	0x2f88b,	0x5eb0,	/* 庰 庰 */
	0x2f88c,	0x5eb3,	/* 庳 庳 */
	0x2f88d,	0x5eb6,	/* 庶 庶 */
	0x2f88e,	0x5eca,	/* 廊 廊 */
	0x2f88f,	0x2a392,	/* 𪎒 𪎒 */
	0x2f890,	0x5efe,	/* 廾 廾 */
	0x2f891,	0x22331,	/* 𢌱 𢌱 */
	0x2f892,	0x22331,	/* 𢌱 𢌱 */
	0x2f893,	0x8201,	/* 舁 舁 */
	0x2f894,	0x5f22,	/* 弢 弢 */
	0x2f895,	0x5f22,	/* 弢 弢 */
	0x2f896,	0x38c7,	/* 㣇 㣇 */
	0x2f897,	0x232b8,	/* 𣊸 𣊸 */
	0x2f898,	0x261da,	/* 𦇚 𦇚 */
	0x2f899,	0x5f62,	/* 形 形 */
	0x2f89a,	0x5f6b,	/* 彫 彫 */
	0x2f89b,	0x38e3,	/* 㣣 㣣 */
	0x2f89c,	0x5f9a,	/* 徚 徚 */
	0x2f89d,	0x5fcd,	/* 忍 忍 */
	0x2f89e,	0x5fd7,	/* 志 志 */
	0x2f89f,	0x5ff9,	/* 忹 忹 */
	0x2f8a0,	0x6081,	/* 悁 悁 */
	0x2f8a1,	0x393a,	/* 㤺 㤺 */
	0x2f8a2,	0x391c,	/* 㤜 㤜 */
	0x2f8a3,	0x6094,	/* 悔 悔 */
	0x2f8a4,	0x226d4,	/* 𢛔 𢛔 */
	0x2f8a5,	0x60c7,	/* 惇 惇 */
	0x2f8a6,	0x6148,	/* 慈 慈 */
	0x2f8a7,	0x614c,	/* 慌 慌 */
	0x2f8a8,	0x614e,	/* 慎 慎 */
	0x2f8a9,	0x614c,	/* 慌 慌 */
	0x2f8aa,	0x617a,	/* 慺 慺 */
	0x2f8ab,	0x618e,	/* 憎 憎 */
	0x2f8ac,	0x61b2,	/* 憲 憲 */
	0x2f8ad,	0x61a4,	/* 憤 憤 */
	0x2f8ae,	0x61af,	/* 憯 憯 */
	0x2f8af,	0x61de,	/* 懞 懞 */
	0x2f8b0,	0x61f2,	/* 懲 懲 */
	0x2f8b1,	0x61f6,	/* 懶 懶 */
	0x2f8b2,	0x6210,	/* 成 成 */
	0x2f8b3,	0x621b,	/* 戛 戛 */
	0x2f8b4,	0x625d,	/* 扝 扝 */
	0x2f8b5,	0x62b1,	/* 抱 抱 */
	0x2f8b6,	0x62d4,	/* 拔 拔 */
	0x2f8b7,	0x6350,	/* 捐 捐 */
	0x2f8b8,	0x22b0c,	/* 𢬌 𢬌 */
	0x2f8b9,	0x633d,	/* 挽 挽 */
	0x2f8ba,	0x62fc,	/* 拼 拼 */
	0x2f8bb,	0x6368,	/* 捨 捨 */
	0x2f8bc,	0x6383,	/* 掃 掃 */
	0x2f8bd,	0x63e4,	/* 揤 揤 */
	0x2f8be,	0x22bf1,	/* 𢯱 𢯱 */
	0x2f8bf,	0x6422,	/* 搢 搢 */
	0x2f8c0,	0x63c5,	/* 揅 揅 */
	0x2f8c1,	0x63a9,	/* 掩 掩 */
	0x2f8c2,	0x3a2e,	/* 㨮 㨮 */
	0x2f8c3,	0x6469,	/* 摩 摩 */
	0x2f8c4,	0x647e,	/* 摾 摾 */
	0x2f8c5,	0x649d,	/* 撝 撝 */
	0x2f8c6,	0x6477,	/* 摷 摷 */
	0x2f8c7,	0x3a6c,	/* 㩬 㩬 */
	0x2f8c8,	0x654f,	/* 敏 敏 */
	0x2f8c9,	0x656c,	/* 敬 敬 */
	0x2f8ca,	0x2300a,	/* 𣀊 𣀊 */
	0x2f8cb,	0x65e3,	/* 旣 旣 */
	0x2f8cc,	0x66f8,	/* 書 書 */
	0x2f8cd,	0x6649,	/* 晉 晉 */
	0x2f8ce,	0x3b19,	/* 㬙 㬙 */
	0x2f8cf,	0x6691,	/* 暑 暑 */
	0x2f8d0,	0x3b08,	/* 㬈 㬈 */
	0x2f8d1,	0x3ae4,	/* 㫤 㫤 */
	0x2f8d2,	0x5192,	/* 冒 冒 */
	0x2f8d3,	0x5195,	/* 冕 冕 */
	0x2f8d4,	0x6700,	/* 最 最 */
	0x2f8d5,	0x669c,	/* 暜 暜 */
	0x2f8d6,	0x80ad,	/* 肭 肭 */
	0x2f8d7,	0x43d9,	/* 䏙 䏙 */
	0x2f8d8,	0x6717,	/* 朗 朗 */
	0x2f8d9,	0x671b,	/* 望 望 */
	0x2f8da,	0x6721,	/* 朡 朡 */
	0x2f8db,	0x675e,	/* 杞 杞 */
	0x2f8dc,	0x6753,	/* 杓 杓 */
	0x2f8dd,	0x233c3,	/* 𣏃 𣏃 */
	0x2f8de,	0x3b49,	/* 㭉 㭉 */
	0x2f8df,	0x67fa,	/* 柺 柺 */
	0x2f8e0,	0x6785,	/* 枅 枅 */
	0x2f8e1,	0x6852,	/* 桒 桒 */
	0x2f8e2,	0x6885,	/* 梅 梅 */
	0x2f8e3,	0x2346d,	/* 𣑭 𣑭 */
	0x2f8e4,	0x688e,	/* 梎 梎 */
	0x2f8e5,	0x681f,	/* 栟 栟 */
	0x2f8e6,	0x6914,	/* 椔 椔 */
	0x2f8e7,	0x3b9d,	/* 㮝 㮝 */
	0x2f8e8,	0x6942,	/* 楂 楂 */
	0x2f8e9,	0x69a3,	/* 榣 榣 */
	0x2f8ea,	0x69ea,	/* 槪 槪 */
	0x2f8eb,	0x6aa8,	/* 檨 檨 */
	0x2f8ec,	0x236a3,	/* 𣚣 𣚣 */
	0x2f8ed,	0x6adb,	/* 櫛 櫛 */
	0x2f8ee,	0x3c18,	/* 㰘 㰘 */
	0x2f8ef,	0x6b21,	/* 次 次 */
	0x2f8f0,	0x238a7,	/* 𣢧 𣢧 */
	0x2f8f1,	0x6b54,	/* 歔 歔 */
	0x2f8f2,	0x3c4e,	/* 㱎 㱎 */
	0x2f8f3,	0x6b72,	/* 歲 歲 */
	0x2f8f4,	0x6b9f,	/* 殟 殟 */
	0x2f8f5,	0x6bba,	/* 殺 殺 */
	0x2f8f6,	0x6bbb,	/* 殻 殻 */
	0x2f8f7,	0x23a8d,	/* 𣪍 𣪍 */
	0x2f8f8,	0x21d0b,	/* 𡴋 𡴋 */
	0x2f8f9,	0x23afa,	/* 𣫺 𣫺 */
	0x2f8fa,	0x6c4e,	/* 汎 汎 */
	0x2f8fb,	0x23cbc,	/* 𣲼 𣲼 */
	0x2f8fc,	0x6cbf,	/* 沿 沿 */
	0x2f8fd,	0x6ccd,	/* 泍 泍 */
	0x2f8fe,	0x6c67,	/* 汧 汧 */
	0x2f8ff,	0x6d16,	/* 洖 洖 */
	0x2f900,	0x6d3e,	/* 派 派 */
	0x2f901,	0x6d77,	/* 海 海 */
	0x2f902,	0x6d41,	/* 流 流 */
	0x2f903,	0x6d69,	/* 浩 浩 */
	0x2f904,	0x6d78,	/* 浸 浸 */
	0x2f905,	0x6d85,	/* 涅 涅 */
	0x2f906,	0x23d1e,	/* 𣴞 𣴞 */
	0x2f907,	0x6d34,	/* 洴 洴 */
	0x2f908,	0x6e2f,	/* 港 港 */
	0x2f909,	0x6e6e,	/* 湮 湮 */
	0x2f90a,	0x3d33,	/* 㴳 㴳 */
	0x2f90b,	0x6ecb,	/* 滋 滋 */
	0x2f90c,	0x6ec7,	/* 滇 滇 */
	0x2f90d,	0x23ed1,	/* 𣻑 𣻑 */
	0x2f90e,	0x6df9,	/* 淹 淹 */
	0x2f90f,	0x6f6e,	/* 潮 潮 */
	0x2f910,	0x23f5e,	/* 𣽞 𣽞 */
	0x2f911,	0x23f8e,	/* 𣾎 𣾎 */
	0x2f912,	0x6fc6,	/* 濆 濆 */
	0x2f913,	0x7039,	/* 瀹 瀹 */
	0x2f914,	0x701e,	/* 瀞 瀞 */
	0x2f915,	0x701b,	/* 瀛 瀛 */
	0x2f916,	0x3d96,	/* 㶖 㶖 */
	0x2f917,	0x704a,	/* 灊 灊 */
	0x2f918,	0x707d,	/* 災 災 */
	0x2f919,	0x7077,	/* 灷 灷 */
	0x2f91a,	0x70ad,	/* 炭 炭 */
	0x2f91b,	0x20525,	/* 𠔥 𠔥 */
	0x2f91c,	0x7145,	/* 煅 煅 */
	0x2f91d,	0x24263,	/* 𤉣 𤉣 */
	0x2f91e,	0x719c,	/* 熜 熜 */
	0x2f91f,	0x243ab,	/* 𤎫 𤎫 */
	0x2f920,	0x7228,	/* 爨 爨 */
	0x2f921,	0x7235,	/* 爵 爵 */
	0x2f922,	0x7250,	/* 牐 牐 */
	0x2f923,	0x24608,	/* 𤘈 𤘈 */
	0x2f924,	0x7280,	/* 犀 犀 */
	0x2f925,	0x7295,	/* 犕 犕 */
	0x2f926,	0x24735,	/* 𤜵 𤜵 */
	0x2f927,	0x24814,	/* 𤠔 𤠔 */
	0x2f928,	0x737a,	/* 獺 獺 */
	0x2f929,	0x738b,	/* 王 王 */
	0x2f92a,	0x3eac,	/* 㺬 㺬 */
	0x2f92b,	0x73a5,	/* 玥 玥 */
	0x2f92c,	0x3eb8,	/* 㺸 㺸 */
	0x2f92d,	0x3eb8,	/* 㺸 㺸 */
	0x2f92e,	0x7447,	/* 瑇 瑇 */
	0x2f92f,	0x745c,	/* 瑜 瑜 */
	0x2f930,	0x7471,	/* 瑱 瑱 */
	0x2f931,	0x7485,	/* 璅 璅 */
	0x2f932,	0x74ca,	/* 瓊 瓊 */
	0x2f933,	0x3f1b,	/* 㼛 㼛 */
	0x2f934,	0x7524,	/* 甤 甤 */
	0x2f935,	0x24c36,	/* 𤰶 𤰶 */
	0x2f936,	0x753e,	/* 甾 甾 */
	0x2f937,	0x24c92,	/* 𤲒 𤲒 */
	0x2f938,	0x7570,	/* 異 異 */
	0x2f939,	0x2219f,	/* 𢆟 𢆟 */
	0x2f93a,	0x7610,	/* 瘐 瘐 */
	0x2f93b,	0x24fa1,	/* 𤾡 𤾡 */
	0x2f93c,	0x24fb8,	/* 𤾸 𤾸 */
	0x2f93d,	0x25044,	/* 𥁄 𥁄 */
	0x2f93e,	0x3ffc,	/* 㿼 㿼 */
	0x2f93f,	0x4008,	/* 䀈 䀈 */
	0x2f940,	0x76f4,	/* 直 直 */
	0x2f941,	0x250f3,	/* 𥃳 𥃳 */
	0x2f942,	0x250f2,	/* 𥃲 𥃲 */
	0x2f943,	0x25119,	/* 𥄙 𥄙 */
	0x2f944,	0x25133,	/* 𥄳 𥄳 */
	0x2f945,	0x771e,	/* 眞 眞 */
	0x2f946,	0x771f,	/* 真 真 */
	0x2f947,	0x771f,	/* 真 真 */
	0x2f948,	0x774a,	/* 睊 睊 */
	0x2f949,	0x4039,	/* 䀹 䀹 */
	0x2f94a,	0x778b,	/* 瞋 瞋 */
	0x2f94b,	0x4046,	/* 䁆 䁆 */
	0x2f94c,	0x4096,	/* 䂖 䂖 */
	0x2f94d,	0x2541d,	/* 𥐝 𥐝 */
	0x2f94e,	0x784e,	/* 硎 硎 */
	0x2f94f,	0x788c,	/* 碌 碌 */
	0x2f950,	0x78cc,	/* 磌 磌 */
	0x2f951,	0x40e3,	/* 䃣 䃣 */
	0x2f952,	0x25626,	/* 𥘦 𥘦 */
	0x2f953,	0x7956,	/* 祖 祖 */
	0x2f954,	0x2569a,	/* 𥚚 𥚚 */
	0x2f955,	0x256c5,	/* 𥛅 𥛅 */
	0x2f956,	0x798f,	/* 福 福 */
	0x2f957,	0x79eb,	/* 秫 秫 */
	0x2f958,	0x412f,	/* 䄯 䄯 */
	0x2f959,	0x7a40,	/* 穀 穀 */
	0x2f95a,	0x7a4a,	/* 穊 穊 */
	0x2f95b,	0x7a4f,	/* 穏 穏 */
	0x2f95c,	0x2597c,	/* 𥥼 𥥼 */
	0x2f95d,	0x25aa7,	/* 𥪧 𥪧 */
	0x2f95e,	0x25aa7,	/* 𥪧 𥪧 */
	0x2f95f,	0x7aee,	/* 竮 竮 */
	0x2f960,	0x4202,	/* 䈂 䈂 */
	0x2f961,	0x25bab,	/* 𥮫 𥮫 */
	0x2f962,	0x7bc6,	/* 篆 篆 */
	0x2f963,	0x7bc9,	/* 築 築 */
	0x2f964,	0x4227,	/* 䈧 䈧 */
	0x2f965,	0x25c80,	/* 𥲀 𥲀 */
	0x2f966,	0x7cd2,	/* 糒 糒 */
	0x2f967,	0x42a0,	/* 䊠 䊠 */
	0x2f968,	0x7ce8,	/* 糨 糨 */
	0x2f969,	0x7ce3,	/* 糣 糣 */
	0x2f96a,	0x7d00,	/* 紀 紀 */
	0x2f96b,	0x25f86,	/* 𥾆 𥾆 */
	0x2f96c,	0x7d63,	/* 絣 絣 */
	0x2f96d,	0x4301,	/* 䌁 䌁 */
	0x2f96e,	0x7dc7,	/* 緇 緇 */
	0x2f96f,	0x7e02,	/* 縂 縂 */
	0x2f970,	0x7e45,	/* 繅 繅 */
	0x2f971,	0x4334,	/* 䌴 䌴 */
	0x2f972,	0x26228,	/* 𦈨 𦈨 */
	0x2f973,	0x26247,	/* 𦉇 𦉇 */
	0x2f974,	0x4359,	/* 䍙 䍙 */
	0x2f975,	0x262d9,	/* 𦋙 𦋙 */
	0x2f976,	0x7f7a,	/* 罺 罺 */
	0x2f977,	0x2633e,	/* 𦌾 𦌾 */
	0x2f978,	0x7f95,	/* 羕 羕 */
	0x2f979,	0x7ffa,	/* 翺 翺 */
	0x2f97a,	0x8005,	/* 者 者 */
	0x2f97b,	0x264da,	/* 𦓚 𦓚 */
	0x2f97c,	0x26523,	/* 𦔣 𦔣 */
	0x2f97d,	0x8060,	/* 聠 聠 */
	0x2f97e,	0x265a8,	/* 𦖨 𦖨 */
	0x2f97f,	0x8070,	/* 聰 聰 */
	0x2f980,	0x2335f,	/* 𣍟 𣍟 */
	0x2f981,	0x43d5,	/* 䏕 䏕 */
	0x2f982,	0x80b2,	/* 育 育 */
	0x2f983,	0x8103,	/* 脃 脃 */
	0x2f984,	0x440b,	/* 䐋 䐋 */
	0x2f985,	0x813e,	/* 脾 脾 */
	0x2f986,	0x5ab5,	/* 媵 媵 */
	0x2f987,	0x267a7,	/* 𦞧 𦞧 */
	0x2f988,	0x267b5,	/* 𦞵 𦞵 */
	0x2f989,	0x23393,	/* 𣎓 𣎓 */
	0x2f98a,	0x2339c,	/* 𣎜 𣎜 */
	0x2f98b,	0x8201,	/* 舁 舁 */
	0x2f98c,	0x8204,	/* 舄 舄 */
	0x2f98d,	0x8f9e,	/* 辞 辞 */
	0x2f98e,	0x446b,	/* 䑫 䑫 */
	0x2f98f,	0x8291,	/* 芑 芑 */
	0x2f990,	0x828b,	/* 芋 芋 */
	0x2f991,	0x829d,	/* 芝 芝 */
	0x2f992,	0x52b3,	/* 劳 劳 */
	0x2f993,	0x82b1,	/* 花 花 */
	0x2f994,	0x82b3,	/* 芳 芳 */
	0x2f995,	0x82bd,	/* 芽 芽 */
	0x2f996,	0x82e6,	/* 苦 苦 */
	0x2f997,	0x26b3c,	/* 𦬼 𦬼 */
	0x2f998,	0x82e5,	/* 若 若 */
	0x2f999,	0x831d,	/* 茝 茝 */
	0x2f99a,	0x8363,	/* 荣 荣 */
	0x2f99b,	0x83ad,	/* 莭 莭 */
	0x2f99c,	0x8323,	/* 茣 茣 */
	0x2f99d,	0x83bd,	/* 莽 莽 */
	0x2f99e,	0x83e7,	/* 菧 菧 */
	0x2f99f,	0x8457,	/* 著 著 */
	0x2f9a0,	0x8353,	/* 荓 荓 */
	0x2f9a1,	0x83ca,	/* 菊 菊 */
	0x2f9a2,	0x83cc,	/* 菌 菌 */
	0x2f9a3,	0x83dc,	/* 菜 菜 */
	0x2f9a4,	0x26c36,	/* 𦰶 𦰶 */
	0x2f9a5,	0x26d6b,	/* 𦵫 𦵫 */
	0x2f9a6,	0x26cd5,	/* 𦳕 𦳕 */
	0x2f9a7,	0x452b,	/* 䔫 䔫 */
	0x2f9a8,	0x84f1,	/* 蓱 蓱 */
	0x2f9a9,	0x84f3,	/* 蓳 蓳 */
	0x2f9aa,	0x8516,	/* 蔖 蔖 */
	0x2f9ab,	0x273ca,	/* 𧏊 𧏊 */
	0x2f9ac,	0x8564,	/* 蕤 蕤 */
	0x2f9ad,	0x26f2c,	/* 𦼬 𦼬 */
	0x2f9ae,	0x455d,	/* 䕝 䕝 */
	0x2f9af,	0x4561,	/* 䕡 䕡 */
	0x2f9b0,	0x26fb1,	/* 𦾱 𦾱 */
	0x2f9b1,	0x270d2,	/* 𧃒 𧃒 */
	0x2f9b2,	0x456b,	/* 䕫 䕫 */
	0x2f9b3,	0x8650,	/* 虐 虐 */
	0x2f9b4,	0x865c,	/* 虜 虜 */
	0x2f9b5,	0x8667,	/* 虧 虧 */
	0x2f9b6,	0x8669,	/* 虩 虩 */
	0x2f9b7,	0x86a9,	/* 蚩 蚩 */
	0x2f9b8,	0x8688,	/* 蚈 蚈 */
	0x2f9b9,	0x870e,	/* 蜎 蜎 */
	0x2f9ba,	0x86e2,	/* 蛢 蛢 */
	0x2f9bb,	0x8779,	/* 蝹 蝹 */
	0x2f9bc,	0x8728,	/* 蜨 蜨 */
	0x2f9bd,	0x876b,	/* 蝫 蝫 */
	0x2f9be,	0x8786,	/* 螆 螆 */
	0x2f9bf,	0x45d7,	/* 䗗 䗗 */
	0x2f9c0,	0x87e1,	/* 蟡 蟡 */
	0x2f9c1,	0x8801,	/* 蠁 蠁 */
	0x2f9c2,	0x45f9,	/* 䗹 䗹 */
	0x2f9c3,	0x8860,	/* 衠 衠 */
	0x2f9c4,	0x8863,	/* 衣 衣 */
	0x2f9c5,	0x27667,	/* 𧙧 𧙧 */
	0x2f9c6,	0x88d7,	/* 裗 裗 */
	0x2f9c7,	0x88de,	/* 裞 裞 */
	0x2f9c8,	0x4635,	/* 䘵 䘵 */
	0x2f9c9,	0x88fa,	/* 裺 裺 */
	0x2f9ca,	0x34bb,	/* 㒻 㒻 */
	0x2f9cb,	0x278ae,	/* 𧢮 𧢮 */
	0x2f9cc,	0x27966,	/* 𧥦 𧥦 */
	0x2f9cd,	0x46be,	/* 䚾 䚾 */
	0x2f9ce,	0x46c7,	/* 䛇 䛇 */
	0x2f9cf,	0x8aa0,	/* 誠 誠 */
	0x2f9d0,	0x8aed,	/* 諭 諭 */
	0x2f9d1,	0x8b8a,	/* 變 變 */
	0x2f9d2,	0x8c55,	/* 豕 豕 */
	0x2f9d3,	0x27ca8,	/* 𧲨 𧲨 */
	0x2f9d4,	0x8cab,	/* 貫 貫 */
	0x2f9d5,	0x8cc1,	/* 賁 賁 */
	0x2f9d6,	0x8d1b,	/* 贛 贛 */
	0x2f9d7,	0x8d77,	/* 起 起 */
	0x2f9d8,	0x27f2f,	/* 𧼯 𧼯 */
	0x2f9d9,	0x20804,	/* 𠠄 𠠄 */
	0x2f9da,	0x8dcb,	/* 跋 跋 */
	0x2f9db,	0x8dbc,	/* 趼 趼 */
	0x2f9dc,	0x8df0,	/* 跰 跰 */
	0x2f9dd,	0x208de,	/* 𠣞 𠣞 */
	0x2f9de,	0x8ed4,	/* 軔 軔 */
	0x2f9df,	0x8f38,	/* 輸 輸 */
	0x2f9e0,	0x285d2,	/* 𨗒 𨗒 */
	0x2f9e1,	0x285ed,	/* 𨗭 𨗭 */
	0x2f9e2,	0x9094,	/* 邔 邔 */
	0x2f9e3,	0x90f1,	/* 郱 郱 */
	0x2f9e4,	0x9111,	/* 鄑 鄑 */
	0x2f9e5,	0x2872e,	/* 𨜮 𨜮 */
	0x2f9e6,	0x911b,	/* 鄛 鄛 */
	0x2f9e7,	0x9238,	/* 鈸 鈸 */
	0x2f9e8,	0x92d7,	/* 鋗 鋗 */
	0x2f9e9,	0x92d8,	/* 鋘 鋘 */
	0x2f9ea,	0x927c,	/* 鉼 鉼 */
	0x2f9eb,	0x93f9,	/* 鏹 鏹 */
	0x2f9ec,	0x9415,	/* 鐕 鐕 */
	0x2f9ed,	0x28bfa,	/* 𨯺 𨯺 */
	0x2f9ee,	0x958b,	/* 開 開 */
	0x2f9ef,	0x4995,	/* 䦕 䦕 */
	0x2f9f0,	0x95b7,	/* 閷 閷 */
	0x2f9f1,	0x28d77,	/* 𨵷 𨵷 */
	0x2f9f2,	0x49e6,	/* 䧦 䧦 */
	0x2f9f3,	0x96c3,	/* 雃 雃 */
	0x2f9f4,	0x5db2,	/* 嶲 嶲 */
	0x2f9f5,	0x9723,	/* 霣 霣 */
	0x2f9f6,	0x29145,	/* 𩅅 𩅅 */
	0x2f9f7,	0x2921a,	/* 𩈚 𩈚 */
	0x2f9f8,	0x4a6e,	/* 䩮 䩮 */
	0x2f9f9,	0x4a76,	/* 䩶 䩶 */
	0x2f9fa,	0x97e0,	/* 韠 韠 */
	0x2f9fb,	0x2940a,	/* 𩐊 𩐊 */
	0x2f9fc,	0x4ab2,	/* 䪲 䪲 */
	0x2f9fd,	0x29496,	/* 𩒖 𩒖 */
	0x2f9fe,	0x980b,	/* 頋 頋 */
	0x2f9ff,	0x980b,	/* 頋 頋 */
	0x2fa00,	0x9829,	/* 頩 頩 */
	0x2fa01,	0x295b6,	/* 𩖶 𩖶 */
	0x2fa02,	0x98e2,	/* 飢 飢 */
	0x2fa03,	0x4b33,	/* 䬳 䬳 */
	0x2fa04,	0x9929,	/* 餩 餩 */
	0x2fa05,	0x99a7,	/* 馧 馧 */
	0x2fa06,	0x99c2,	/* 駂 駂 */
	0x2fa07,	0x99fe,	/* 駾 駾 */
	0x2fa08,	0x4bce,	/* 䯎 䯎 */
	0x2fa09,	0x29b30,	/* 𩬰 𩬰 */
	0x2fa0a,	0x9b12,	/* 鬒 鬒 */
	0x2fa0b,	0x9c40,	/* 鱀 鱀 */
	0x2fa0c,	0x9cfd,	/* 鳽 鳽 */
	0x2fa0d,	0x4cce,	/* 䳎 䳎 */
	0x2fa0e,	0x4ced,	/* 䳭 䳭 */
	0x2fa0f,	0x9d67,	/* 鵧 鵧 */
	0x2fa10,	0x2a0ce,	/* 𪃎 𪃎 */
	0x2fa11,	0x4cf8,	/* 䳸 䳸 */
	0x2fa12,	0x2a105,	/* 𪄅 𪄅 */
	0x2fa13,	0x2a20e,	/* 𪈎 𪈎 */
	0x2fa14,	0x2a291,	/* 𪊑 𪊑 */
	0x2fa15,	0x9ebb,	/* 麻 麻 */
	0x2fa16,	0x4d56,	/* 䵖 䵖 */
	0x2fa17,	0x9ef9,	/* 黹 黹 */
	0x2fa18,	0x9efe,	/* 黾 黾 */
	0x2fa19,	0x9f05,	/* 鼅 鼅 */
	0x2fa1a,	0x9f0f,	/* 鼏 鼏 */
	0x2fa1b,	0x9f16,	/* 鼖 鼖 */
	0x2fa1c,	0x9f3b,	/* 鼻 鼻 */
};

Rune
tobaserune(Rune c)
{
	Rune *p;

	p = _runebsearch(c, _base2, nelem(_base2)/2, 2);
	if(p && c == p[0])
		c = p[1];
	return c;
}

int
isbaserune(Rune c)
{
	return tobaserune(c) == c;
}
